/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.SinkFactory;

public class RandomAccessSink
implements Sink {
    private SinkFactory sinkFactory;
    private String encoding;
    private OutputStream coreOutputStream;
    private Sink coreSink;
    private List<Sink> sinks = new ArrayList<Sink>();
    private List<ByteArrayOutputStream> outputStreams = new ArrayList<ByteArrayOutputStream>();
    private Sink currentSink;

    public RandomAccessSink(SinkFactory sinkFactory, OutputStream stream) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = stream;
        this.coreSink = this.currentSink = sinkFactory.createSink(stream);
    }

    public RandomAccessSink(SinkFactory sinkFactory, OutputStream stream, String encoding) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = stream;
        this.encoding = encoding;
        this.coreSink = this.currentSink = sinkFactory.createSink(stream, encoding);
    }

    public RandomAccessSink(SinkFactory sinkFactory, File outputDirectory, String outputName) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = new FileOutputStream(new File(outputDirectory, outputName));
        this.coreSink = this.currentSink = sinkFactory.createSink(this.coreOutputStream);
    }

    public RandomAccessSink(SinkFactory sinkFactory, File outputDirectory, String outputName, String encoding) throws IOException {
        this.sinkFactory = sinkFactory;
        this.coreOutputStream = new FileOutputStream(new File(outputDirectory, outputName));
        this.encoding = encoding;
        this.coreSink = this.currentSink = sinkFactory.createSink(this.coreOutputStream, encoding);
    }

    @Override
    public void address() {
        this.currentSink.address();
    }

    @Override
    public void address(SinkEventAttributes attributes) {
        this.currentSink.address(attributes);
    }

    @Override
    public void address_() {
        this.currentSink.address_();
    }

    public Sink addSinkHook() {
        Sink subSink = null;
        try {
            ByteArrayOutputStream subOut = new ByteArrayOutputStream();
            ByteArrayOutputStream newOut = new ByteArrayOutputStream();
            this.outputStreams.add(subOut);
            this.outputStreams.add(newOut);
            if (this.encoding != null) {
                subSink = this.sinkFactory.createSink(subOut, this.encoding);
                this.currentSink = this.sinkFactory.createSink(newOut, this.encoding);
            } else {
                subSink = this.sinkFactory.createSink(subOut);
                this.currentSink = this.sinkFactory.createSink(newOut);
            }
            this.sinks.add(subSink);
            this.sinks.add(this.currentSink);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return subSink;
    }

    @Override
    public void anchor(String name) {
        this.currentSink.anchor(name);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        this.currentSink.anchor(name, attributes);
    }

    @Override
    public void anchor_() {
        this.currentSink.anchor_();
    }

    @Override
    public void article() {
        this.currentSink.article();
    }

    @Override
    public void article(SinkEventAttributes attributes) {
        this.currentSink.article(attributes);
    }

    @Override
    public void article_() {
        this.currentSink.article_();
    }

    @Override
    public void author() {
        this.currentSink.author();
    }

    @Override
    public void author(SinkEventAttributes attributes) {
        this.currentSink.author(attributes);
    }

    @Override
    public void author_() {
        this.currentSink.author_();
    }

    @Override
    public void blockquote() {
        this.currentSink.blockquote();
    }

    @Override
    public void blockquote(SinkEventAttributes attributes) {
        this.currentSink.blockquote(attributes);
    }

    @Override
    public void blockquote_() {
        this.currentSink.blockquote_();
    }

    @Override
    public void body() {
        this.currentSink.body();
    }

    @Override
    public void body(SinkEventAttributes attributes) {
        this.currentSink.body(attributes);
    }

    @Override
    public void body_() {
        this.currentSink.body_();
    }

    @Override
    public void bold() {
        this.currentSink.bold();
    }

    @Override
    public void bold_() {
        this.currentSink.bold_();
    }

    @Override
    public void close() {
        for (Sink sink : this.sinks) {
            sink.close();
        }
        this.coreSink.close();
    }

    @Override
    public void comment(String comment) {
        this.currentSink.comment(comment);
    }

    @Override
    public void content() {
        this.currentSink.content();
    }

    @Override
    public void content(SinkEventAttributes attributes) {
        this.currentSink.content(attributes);
    }

    @Override
    public void content_() {
        this.currentSink.content_();
    }

    @Override
    public void data(String value) {
        this.currentSink.data(value);
    }

    @Override
    public void data(String value, SinkEventAttributes attributes) {
        this.currentSink.data(value, attributes);
    }

    @Override
    public void data_() {
        this.currentSink.data_();
    }

    @Override
    public void date() {
        this.currentSink.date();
    }

    @Override
    public void date(SinkEventAttributes attributes) {
        this.currentSink.date(attributes);
    }

    @Override
    public void date_() {
        this.currentSink.date_();
    }

    @Override
    public void definedTerm() {
        this.currentSink.definedTerm();
    }

    @Override
    public void definedTerm(SinkEventAttributes attributes) {
        this.currentSink.definedTerm(attributes);
    }

    @Override
    public void definedTerm_() {
        this.currentSink.definedTerm_();
    }

    @Override
    public void definition() {
        this.currentSink.definition();
    }

    @Override
    public void definition(SinkEventAttributes attributes) {
        this.currentSink.definition(attributes);
    }

    @Override
    public void definitionList() {
        this.currentSink.definitionList();
    }

    @Override
    public void definitionList(SinkEventAttributes attributes) {
        this.currentSink.definitionList(attributes);
    }

    @Override
    public void definitionListItem() {
        this.currentSink.definitionListItem();
    }

    @Override
    public void definitionListItem(SinkEventAttributes attributes) {
        this.currentSink.definitionListItem(attributes);
    }

    @Override
    public void definitionListItem_() {
        this.currentSink.definitionListItem_();
    }

    @Override
    public void definitionList_() {
        this.currentSink.definitionList_();
    }

    @Override
    public void definition_() {
        this.currentSink.definition_();
    }

    @Override
    public void division() {
        this.currentSink.division();
    }

    @Override
    public void division(SinkEventAttributes attributes) {
        this.currentSink.division(attributes);
    }

    @Override
    public void division_() {
        this.currentSink.division_();
    }

    @Override
    public void figure() {
        this.currentSink.figure();
    }

    @Override
    public void figure(SinkEventAttributes attributes) {
        this.currentSink.figure(attributes);
    }

    @Override
    public void figureCaption() {
        this.currentSink.figureCaption();
    }

    @Override
    public void figureCaption(SinkEventAttributes attributes) {
        this.currentSink.figureCaption(attributes);
    }

    @Override
    public void figureCaption_() {
        this.currentSink.figureCaption_();
    }

    @Override
    public void figureGraphics(String name) {
        this.currentSink.figureGraphics(name);
    }

    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        this.currentSink.figureGraphics(src, attributes);
    }

    @Override
    public void figure_() {
        this.currentSink.figure_();
    }

    @Override
    public void flush() {
        for (int i = 0; i < this.sinks.size(); ++i) {
            Sink sink = this.sinks.get(i);
            sink.flush();
            ByteArrayOutputStream stream = this.outputStreams.get(i);
            try {
                this.coreOutputStream.write(stream.toByteArray());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.coreSink.flush();
    }

    @Override
    public void footer() {
        this.currentSink.footer();
    }

    @Override
    public void footer(SinkEventAttributes attributes) {
        this.currentSink.footer(attributes);
    }

    @Override
    public void footer_() {
        this.currentSink.footer_();
    }

    @Override
    public void head() {
        this.currentSink.head();
    }

    @Override
    public void head(SinkEventAttributes attributes) {
        this.currentSink.head(attributes);
    }

    @Override
    public void head_() {
        this.currentSink.head_();
    }

    @Override
    public void header() {
        this.currentSink.header();
    }

    @Override
    public void header(SinkEventAttributes attributes) {
        this.currentSink.header(attributes);
    }

    @Override
    public void header_() {
        this.currentSink.header_();
    }

    @Override
    public void horizontalRule() {
        this.currentSink.horizontalRule();
    }

    @Override
    public void horizontalRule(SinkEventAttributes attributes) {
        this.currentSink.horizontalRule(attributes);
    }

    @Override
    public void inline() {
        this.currentSink.inline();
    }

    @Override
    public void inline(SinkEventAttributes attributes) {
        this.currentSink.inline(attributes);
    }

    @Override
    public void inline_() {
        this.currentSink.inline_();
    }

    @Override
    public void italic() {
        this.currentSink.italic();
    }

    @Override
    public void italic_() {
        this.currentSink.italic_();
    }

    @Override
    public void lineBreak() {
        this.currentSink.lineBreak();
    }

    @Override
    public void lineBreak(SinkEventAttributes attributes) {
        this.currentSink.lineBreak(attributes);
    }

    @Override
    public void lineBreakOpportunity() {
        this.currentSink.lineBreakOpportunity();
    }

    @Override
    public void lineBreakOpportunity(SinkEventAttributes attributes) {
        this.currentSink.lineBreakOpportunity(attributes);
    }

    @Override
    public void link(String name) {
        this.currentSink.link(name);
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        this.currentSink.link(name, attributes);
    }

    @Override
    public void link_() {
        this.currentSink.link_();
    }

    @Override
    public void list() {
        this.currentSink.list();
    }

    @Override
    public void list(SinkEventAttributes attributes) {
        this.currentSink.list(attributes);
    }

    @Override
    public void listItem() {
        this.currentSink.listItem();
    }

    @Override
    public void listItem(SinkEventAttributes attributes) {
        this.currentSink.listItem(attributes);
    }

    @Override
    public void listItem_() {
        this.currentSink.listItem_();
    }

    @Override
    public void list_() {
        this.currentSink.list_();
    }

    @Override
    public void monospaced() {
        this.currentSink.monospaced();
    }

    @Override
    public void monospaced_() {
        this.currentSink.monospaced_();
    }

    @Override
    public void navigation() {
        this.currentSink.navigation();
    }

    @Override
    public void navigation(SinkEventAttributes attributes) {
        this.currentSink.navigation(attributes);
    }

    @Override
    public void navigation_() {
        this.currentSink.navigation_();
    }

    @Override
    public void nonBreakingSpace() {
        this.currentSink.nonBreakingSpace();
    }

    @Override
    public void numberedList(int numbering) {
        this.currentSink.numberedList(numbering);
    }

    @Override
    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.currentSink.numberedList(numbering, attributes);
    }

    @Override
    public void numberedListItem() {
        this.currentSink.numberedListItem();
    }

    @Override
    public void numberedListItem(SinkEventAttributes attributes) {
        this.currentSink.numberedListItem(attributes);
    }

    @Override
    public void numberedListItem_() {
        this.currentSink.numberedListItem_();
    }

    @Override
    public void numberedList_() {
        this.currentSink.numberedList_();
    }

    @Override
    public void pageBreak() {
        this.currentSink.pageBreak();
    }

    @Override
    public void paragraph() {
        this.currentSink.paragraph();
    }

    @Override
    public void paragraph(SinkEventAttributes attributes) {
        this.currentSink.paragraph(attributes);
    }

    @Override
    public void paragraph_() {
        this.currentSink.paragraph_();
    }

    @Override
    public void rawText(String text) {
        this.currentSink.rawText(text);
    }

    @Override
    public void section(int level, SinkEventAttributes attributes) {
        this.currentSink.section(level, attributes);
    }

    @Override
    public void section1() {
        this.currentSink.section1();
    }

    @Override
    public void section1_() {
        this.currentSink.section1_();
    }

    @Override
    public void section2() {
        this.currentSink.section2();
    }

    @Override
    public void section2_() {
        this.currentSink.section2_();
    }

    @Override
    public void section3() {
        this.currentSink.section3();
    }

    @Override
    public void section3_() {
        this.currentSink.section3_();
    }

    @Override
    public void section4() {
        this.currentSink.section4();
    }

    @Override
    public void section4_() {
        this.currentSink.section4_();
    }

    @Override
    public void section5() {
        this.currentSink.section5();
    }

    @Override
    public void section5_() {
        this.currentSink.section5_();
    }

    @Override
    public void section6() {
        this.currentSink.section5();
    }

    @Override
    public void section6_() {
        this.currentSink.section5_();
    }

    @Override
    public void sectionTitle() {
        this.currentSink.sectionTitle();
    }

    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.currentSink.sectionTitle(level, attributes);
    }

    @Override
    public void sectionTitle1() {
        this.currentSink.sectionTitle1();
    }

    @Override
    public void sectionTitle1_() {
        this.currentSink.sectionTitle1_();
    }

    @Override
    public void sectionTitle2() {
        this.currentSink.sectionTitle2();
    }

    @Override
    public void sectionTitle2_() {
        this.currentSink.sectionTitle2_();
    }

    @Override
    public void sectionTitle3() {
        this.currentSink.sectionTitle3();
    }

    @Override
    public void sectionTitle3_() {
        this.currentSink.sectionTitle3_();
    }

    @Override
    public void sectionTitle4() {
        this.currentSink.sectionTitle4();
    }

    @Override
    public void sectionTitle4_() {
        this.currentSink.sectionTitle4_();
    }

    @Override
    public void sectionTitle5() {
        this.currentSink.sectionTitle5();
    }

    @Override
    public void sectionTitle5_() {
        this.currentSink.sectionTitle5_();
    }

    @Override
    public void sectionTitle6() {
        this.currentSink.sectionTitle5();
    }

    @Override
    public void sectionTitle6_() {
        this.currentSink.sectionTitle5_();
    }

    @Override
    public void sectionTitle_() {
        this.currentSink.sectionTitle_();
    }

    @Override
    public void sectionTitle_(int level) {
        this.currentSink.sectionTitle_(level);
    }

    @Override
    public void section_(int level) {
        this.currentSink.section_(level);
    }

    @Override
    public void sidebar() {
        this.currentSink.sidebar();
    }

    @Override
    public void sidebar(SinkEventAttributes attributes) {
        this.currentSink.sidebar(attributes);
    }

    @Override
    public void sidebar_() {
        this.currentSink.sidebar_();
    }

    @Override
    public void table() {
        this.currentSink.table();
    }

    @Override
    public void table(SinkEventAttributes attributes) {
        this.currentSink.table(attributes);
    }

    @Override
    public void tableCaption() {
        this.currentSink.tableCaption();
    }

    @Override
    public void tableCaption(SinkEventAttributes attributes) {
        this.currentSink.tableCaption(attributes);
    }

    @Override
    public void tableCaption_() {
        this.currentSink.tableCaption_();
    }

    @Override
    public void tableCell() {
        this.currentSink.tableCell();
    }

    @Override
    public void tableCell(String width) {
        this.currentSink.tableCell(width);
    }

    @Override
    public void tableCell(SinkEventAttributes attributes) {
        this.currentSink.tableCell(attributes);
    }

    @Override
    public void tableCell_() {
        this.currentSink.tableCell_();
    }

    @Override
    public void tableHeaderCell() {
        this.currentSink.tableHeaderCell();
    }

    @Override
    public void tableHeaderCell(String width) {
        this.currentSink.tableHeaderCell(width);
    }

    @Override
    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.currentSink.tableHeaderCell(attributes);
    }

    @Override
    public void tableHeaderCell_() {
        this.currentSink.tableHeaderCell_();
    }

    @Override
    public void tableRow() {
        this.currentSink.tableRow();
    }

    @Override
    public void tableRow(SinkEventAttributes attributes) {
        this.currentSink.tableRow(attributes);
    }

    @Override
    public void tableRow_() {
        this.currentSink.tableRow_();
    }

    @Override
    public void tableRows(int[] justification, boolean grid) {
        this.currentSink.tableRows(justification, grid);
    }

    @Override
    public void tableRows_() {
        this.currentSink.tableRows_();
    }

    @Override
    public void table_() {
        this.currentSink.table_();
    }

    @Override
    public void text(String text) {
        this.currentSink.text(text);
    }

    @Override
    public void text(String text, SinkEventAttributes attributes) {
        this.currentSink.text(text, attributes);
    }

    @Override
    public void time(String datetime) {
        this.currentSink.time(datetime);
    }

    @Override
    public void time(String datetime, SinkEventAttributes attributes) {
        this.currentSink.time(datetime, attributes);
    }

    @Override
    public void time_() {
        this.currentSink.time_();
    }

    @Override
    public void title() {
        this.currentSink.title();
    }

    @Override
    public void title(SinkEventAttributes attributes) {
        this.currentSink.title(attributes);
    }

    @Override
    public void title_() {
        this.currentSink.title_();
    }

    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.currentSink.unknown(name, requiredParams, attributes);
    }

    @Override
    public void verbatim(boolean boxed) {
        this.currentSink.verbatim(boxed);
    }

    @Override
    public void verbatim(SinkEventAttributes attributes) {
        this.currentSink.verbatim(attributes);
    }

    @Override
    public void verbatim_() {
        this.currentSink.verbatim_();
    }

    @Override
    public void enableLogging(Log log) {
        this.currentSink.enableLogging(log);
    }
}

