/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

class PlexusUtilsInjector
implements DependencyGraphTransformer {
    private static final String GID = "org.codehaus.plexus";
    private static final String AID = "plexus-utils";
    private static final String VER = "1.1";
    private static final String EXT = "jar";

    PlexusUtilsInjector() {
    }

    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        if (this.findPlexusUtils(node) == null) {
            DefaultArtifact pu = new DefaultArtifact(GID, AID, null, EXT, VER);
            DefaultDependencyNode child = new DefaultDependencyNode(new Dependency(pu, "runtime"));
            child.setRepositories(node.getRepositories());
            child.setRequestContext(node.getRequestContext());
            node.getChildren().add(child);
        }
        return node;
    }

    private DependencyNode findPlexusUtils(DependencyNode node) {
        Artifact artifact = node.getDependency().getArtifact();
        if (AID.equals(artifact.getArtifactId()) && GID.equals(artifact.getGroupId()) && EXT.equals(artifact.getExtension()) && "".equals(artifact.getClassifier())) {
            return node;
        }
        for (DependencyNode child : node.getChildren()) {
            DependencyNode result = this.findPlexusUtils(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

