/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.lifecycle.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Lifecycle;
import org.apache.maven.plugin.lifecycle.LifecycleConfiguration;
import org.apache.maven.plugin.lifecycle.Phase;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LifecycleMappingsXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s2, attribute, parser, null);
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s2 != null && s2.length() != 0) {
            return Boolean.valueOf(s2);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Byte.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s2 != null) {
            return s2.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s2, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s2, attribute, null, parser);
    }

    private Date getDateValue(String s2, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s2 != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s2));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s2);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Double.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Float.valueOf(s2).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Integer.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Long.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s2 == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s2;
    }

    private short getShortValue(String s2, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Short.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s2) {
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public LifecycleConfiguration read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public LifecycleConfiguration read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public LifecycleConfiguration read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public LifecycleConfiguration read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private Execution parseExecution(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Execution execution = new Execution();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                execution.setConfiguration(Xpp3DomBuilder.build(parser, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                execution.setGoals(goals);
                while (parser.nextTag() == 2) {
                    if ("goal".equals(parser.getName())) {
                        goals.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return execution;
    }

    private Lifecycle parseLifecycle(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Lifecycle lifecycle = new Lifecycle();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                lifecycle.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phases", null, parsed)) {
                ArrayList<Phase> phases = new ArrayList<Phase>();
                lifecycle.setPhases(phases);
                while (parser.nextTag() == 2) {
                    if ("phase".equals(parser.getName())) {
                        phases.add(this.parsePhase(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return lifecycle;
    }

    private LifecycleConfiguration parseLifecycleConfiguration(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LifecycleConfiguration lifecycleConfiguration = new LifecycleConfiguration();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("lifecycle".equals(parser.getName())) {
                List<Lifecycle> lifecycles = lifecycleConfiguration.getLifecycles();
                if (lifecycles == null) {
                    lifecycles = new ArrayList<Lifecycle>();
                    lifecycleConfiguration.setLifecycles(lifecycles);
                }
                lifecycles.add(this.parseLifecycle(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return lifecycleConfiguration;
    }

    private Phase parsePhase(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Phase phase = new Phase();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "id", null, parsed)) {
                phase.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executions", null, parsed)) {
                ArrayList<Execution> executions = new ArrayList<Execution>();
                phase.setExecutions(executions);
                while (parser.nextTag() == 2) {
                    if ("execution".equals(parser.getName())) {
                        executions.add(this.parseExecution(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "configuration", null, parsed)) {
                phase.setConfiguration(Xpp3DomBuilder.build(parser, true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return phase;
    }

    private LifecycleConfiguration read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"lifecycles".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'lifecycles' but found '" + parser.getName() + "'", parser, null);
                }
                LifecycleConfiguration lifecycleConfiguration = this.parseLifecycleConfiguration(parser, strict);
                lifecycleConfiguration.setModelEncoding(parser.getInputEncoding());
                return lifecycleConfiguration;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'lifecycles' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

