/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.codehaus.plexus.util.FileUtils;

public class AscArtifactMetadata
extends AbstractArtifactMetadata
implements org.apache.maven.shared.transfer.metadata.ArtifactMetadata {
    private final File file;
    private final boolean isPom;

    public AscArtifactMetadata(Artifact artifact, File file, boolean isPom) {
        super(artifact);
        this.file = file;
        this.isPom = isPom;
    }

    @Override
    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    @Override
    public Object getKey() {
        return "gpg signature " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getType() + ":" + this.artifact.getClassifier() + (this.isPom ? ":pom" : "");
    }

    private String getFilename() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getArtifactId());
        buf.append("-").append(this.artifact.getVersion());
        if (this.isPom) {
            buf.append(".pom");
        } else {
            if (this.artifact.getClassifier() != null && !"".equals(this.artifact.getClassifier())) {
                buf.append("-").append(this.artifact.getClassifier());
            }
            buf.append(".").append(this.artifact.getArtifactHandler().getExtension());
        }
        buf.append(".asc");
        return buf.toString();
    }

    @Override
    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    @Override
    public String getRemoteFilename() {
        return this.getFilename();
    }

    @Override
    public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        this.merge((AscArtifactMetadata)metadata);
    }

    @Override
    public void merge(ArtifactMetadata metadata) {
        this.merge((AscArtifactMetadata)metadata);
    }

    private void merge(AscArtifactMetadata metadata) {
        if (!metadata.file.equals(this.file)) {
            throw new IllegalStateException("Cannot add two different pieces of metadata for: " + this.getKey());
        }
    }

    @Override
    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        File destination = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(this, remoteRepository));
        try {
            FileUtils.copyFile(this.file, destination);
        }
        catch (IOException e) {
            throw new RepositoryMetadataStoreException("Error copying ASC to the local repository.", e);
        }
    }

    @Override
    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    public String toString() {
        return this.getFilename();
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

