/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

public class FilesCollector {
    private final MavenProject project;
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.md5", "**/*.sha1", "**/*.sha256", "**/*.sha512", "**/*.asc", "**/*.sigstore"};
    private final String[] excludes;
    private final Log log;

    public FilesCollector(MavenProject project, String[] excludes, Log log) {
        this.project = project;
        this.log = log;
        if (excludes == null || excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            return;
        }
        String[] newExcludes = new String[excludes.length];
        for (int i = 0; i < excludes.length; ++i) {
            String pattern = excludes[i].trim().replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (pattern.endsWith(File.separator)) {
                pattern = pattern + "**";
            }
            newExcludes[i] = pattern;
        }
        this.excludes = newExcludes;
    }

    public List<Item> collect() throws MojoExecutionException, MojoFailureException {
        ArrayList<Item> items = new ArrayList<Item>();
        if (!"pom".equals(this.project.getPackaging())) {
            Artifact artifact = this.project.getArtifact();
            File file = artifact.getFile();
            if (file != null && file.isFile()) {
                items.add(new Item(file, artifact.getArtifactHandler().getExtension()));
            } else {
                if (this.project.getAttachedArtifacts().isEmpty()) {
                    throw new MojoFailureException("The project artifact has not been assembled yet. Please do not invoke this goal before the lifecycle phase \"package\".");
                }
                this.log.debug("Main artifact not assembled, skipping signature generation");
            }
        }
        File pomToSign = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".pom");
        try {
            FileUtils.copyFile(this.project.getFile(), pomToSign);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying POM for signing.", e);
        }
        items.add(new Item(pomToSign, "pom"));
        for (Artifact artifact : this.project.getAttachedArtifacts()) {
            File file = artifact.getFile();
            if (this.isExcluded(artifact)) {
                this.log.debug("Skipping generation of signature for excluded " + file);
                continue;
            }
            items.add(new Item(file, artifact.getClassifier(), artifact.getArtifactHandler().getExtension()));
        }
        return items;
    }

    protected boolean isExcluded(Artifact artifact) {
        Path projectBasePath = this.project.getBasedir().toPath();
        Path artifactPath = artifact.getFile().toPath();
        String relativeArtifactPath = projectBasePath.relativize(artifactPath).toString();
        for (String exclude : this.excludes) {
            if (!SelectorUtils.matchPath(exclude, relativeArtifactPath)) continue;
            return true;
        }
        return false;
    }

    public static class Item {
        private final File file;
        private final String classifier;
        private final String extension;

        public Item(File file, String classifier, String extension) {
            this.file = file;
            this.classifier = classifier;
            this.extension = extension;
        }

        public Item(File file, String extension) {
            this(file, null, extension);
        }

        public File getFile() {
            return this.file;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

