/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.gpg.GpgVersion;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GpgVersionParser {
    private final GpgVersionConsumer consumer;

    private GpgVersionParser(GpgVersionConsumer consumer) {
        this.consumer = consumer;
    }

    public static GpgVersionParser parse(String executable) throws MojoExecutionException {
        Commandline cmd = new Commandline();
        if (StringUtils.isNotEmpty(executable)) {
            cmd.setExecutable(executable);
        } else {
            cmd.setExecutable("gpg" + (Os.isFamily("windows") ? ".exe" : ""));
        }
        cmd.createArg().setValue("--version");
        GpgVersionConsumer out = new GpgVersionConsumer();
        try {
            CommandLineUtils.executeCommandLine(cmd, null, (StreamConsumer)out, null);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("failed to execute gpg", e);
        }
        return new GpgVersionParser(out);
    }

    public GpgVersion getGpgVersion() {
        return this.consumer.getGpgVersion();
    }

    static class GpgVersionConsumer
    implements StreamConsumer {
        private final Pattern gpgVersionPattern = Pattern.compile("gpg \\([^)]+\\) .+");
        private GpgVersion gpgVersion;

        GpgVersionConsumer() {
        }

        @Override
        public void consumeLine(String line) throws IOException {
            Matcher m4 = this.gpgVersionPattern.matcher(line);
            if (m4.matches()) {
                this.gpgVersion = GpgVersion.parse(m4.group());
            }
        }

        public GpgVersion getGpgVersion() {
            return this.gpgVersion;
        }
    }
}

