/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgMojo;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.AscArtifactMetadata;
import org.apache.maven.plugins.gpg.AttachedSignedArtifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployer;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployerException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="sign-and-deploy-file", requiresProject=false, threadSafe=true)
public class SignAndDeployFileMojo
extends AbstractGpgMojo {
    @Parameter(property="gpg.ascDirectory")
    private File ascDirectory;
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="repositoryLayout", defaultValue="default")
    private String repositoryLayout;
    @Component
    private ArtifactDeployer deployer;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ModelValidator modelValidator;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @Parameter(property="updateReleaseInfo", defaultValue="false")
    protected boolean updateReleaseInfo;
    @Parameter(property="types")
    private String types;
    @Parameter(property="classifiers")
    private String classifiers;
    @Parameter(property="files")
    private String files;

    private void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.packaging == null && this.file != null) {
            this.packaging = FileUtils.getExtension(this.file.getName());
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        AbstractGpgSigner signer = this.newSigner(null);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBaseDirectory(new File("").getAbsoluteFile());
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
        this.initProperties();
        this.validateArtifactInformation();
        if (!this.file.exists()) {
            throw new MojoFailureException(this.file.getPath() + " not found.");
        }
        ArtifactRepository deploymentRepository = this.createDeploymentArtifactRepository(this.repositoryId, this.url);
        if (StringUtils.isEmpty(deploymentRepository.getProtocol())) {
            throw new MojoFailureException("No transfer protocol found.");
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.file.equals(this.getLocalRepoFile(artifact))) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        artifact.setFile(this.file);
        File fileSig = signer.generateSignatureForArtifact(this.file);
        AbstractArtifactMetadata metadata = new AscArtifactMetadata(artifact, fileSig, false);
        artifact.addMetadata(metadata);
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile == null && this.generatePom) {
                this.pomFile = this.generatePomFile();
            }
            if (this.pomFile != null) {
                metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata(metadata);
                fileSig = signer.generateSignatureForArtifact(this.pomFile);
                metadata = new AscArtifactMetadata(artifact, fileSig, true);
                artifact.addMetadata(metadata);
            }
        }
        if (this.updateReleaseInfo) {
            artifact.setRelease(true);
        }
        this.project.setArtifact(artifact);
        try {
            this.deploy(artifact, deploymentRepository);
        }
        catch (ArtifactDeployerException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.sources != null) {
            this.projectHelper.attachArtifact(this.project, "jar", "sources", this.sources);
        }
        if (this.javadoc != null) {
            this.projectHelper.attachArtifact(this.project, "jar", "javadoc", this.javadoc);
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoExecutionException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoExecutionException("You must specify 'classifiers' if you specify 'files'");
            }
            int filesLength = StringUtils.countMatches(this.files, ",");
            int typesLength = StringUtils.countMatches(this.types, ",");
            int classifiersLength = StringUtils.countMatches(this.classifiers, ",");
            if (typesLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'types' (respectively " + filesLength + " and " + typesLength + " entries )");
            }
            if (classifiersLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + filesLength + " and " + classifiersLength + " entries )");
            }
            int fi = 0;
            int ti = 0;
            int ci = 0;
            for (int i = 0; i <= filesLength; ++i) {
                File file;
                int nci;
                int nti;
                int nfi = this.files.indexOf(44, fi);
                if (nfi == -1) {
                    nfi = this.files.length();
                }
                if ((nti = this.types.indexOf(44, ti)) == -1) {
                    nti = this.types.length();
                }
                if ((nci = this.classifiers.indexOf(44, ci)) == -1) {
                    nci = this.classifiers.length();
                }
                if (!(file = new File(this.files.substring(fi, nfi))).isFile()) {
                    file = new File(this.project.getBasedir(), this.files.substring(fi, nfi));
                }
                if (file.isFile()) {
                    if (StringUtils.isWhitespace(this.classifiers.substring(ci, nci))) {
                        this.projectHelper.attachArtifact(this.project, this.types.substring(ti, nti).trim(), file);
                    } else {
                        this.projectHelper.attachArtifact(this.project, this.types.substring(ti, nti).trim(), this.classifiers.substring(ci, nci).trim(), file);
                    }
                } else {
                    throw new MojoExecutionException("Specified side artifact " + file + " does not exist");
                }
                fi = nfi + 1;
                ti = nti + 1;
                ci = nci + 1;
            }
        } else {
            if (this.types != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        for (Artifact attached : this.project.getAttachedArtifacts()) {
            fileSig = signer.generateSignatureForArtifact(attached.getFile());
            attached = new AttachedSignedArtifact(attached, new AscArtifactMetadata(attached, fileSig, false));
            try {
                this.deploy(attached, deploymentRepository);
            }
            catch (ArtifactDeployerException e) {
                throw new MojoExecutionException("Error deploying attached artifact " + attached.getFile() + ": " + e.getMessage(), e);
            }
        }
    }

    private File getLocalRepoFile(Artifact artifact) {
        String path = this.localRepository.pathOf(artifact);
        return new File(this.localRepository.getBasedir(), path);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        block10: {
            XmlStreamReader reader = ReaderFactory.newXmlReader(pomFile);
            try {
                Model model2;
                model = model2 = new MavenXpp3Reader().read(reader);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("POM not found " + pomFile, e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading POM " + pomFile, e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing POM " + pomFile, e);
                }
            }
            ((Reader)reader).close();
        }
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        Model model = this.generateModel();
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            try (XmlStreamWriter fw = WriterFactory.newXmlWriter(tempFile);){
                new MavenXpp3Writer().write(fw, model);
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), e);
        }
    }

    private void validateArtifactInformation() throws MojoFailureException {
        Model model = this.generateModel();
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setValidationLevel(20);
        ArrayList<String> result = new ArrayList<String>();
        SimpleModelProblemCollector problemCollector = new SimpleModelProblemCollector(result);
        this.modelValidator.validateEffectiveModel(model, request, problemCollector);
        if (!result.isEmpty()) {
            StringBuilder msg = new StringBuilder("The artifact information is incomplete or not valid:\n");
            for (String e : result) {
                msg.append(" - " + e + '\n');
            }
            throw new MojoFailureException(msg.toString());
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    protected void deploy(Artifact artifact, ArtifactRepository deploymentRepository) throws ArtifactDeployerException {
        ProjectBuildingRequest buildingRequest = this.session.getProjectBuildingRequest();
        int retryFailedDeploymentCount = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        ArtifactDeployerException exception = null;
        for (int count = 0; count < retryFailedDeploymentCount; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCount);
                }
                this.deployer.deploy(buildingRequest, deploymentRepository, Collections.singletonList(artifact));
                Iterator<ArtifactMetadata> iterator = artifact.getMetadataList().iterator();
                while (iterator.hasNext()) {
                    ArtifactMetadata o;
                    ArtifactMetadata metadata = o = iterator.next();
                    this.getLog().info("Metadata[" + metadata.getKey() + "].filename = " + metadata.getRemoteFilename());
                }
                exception = null;
                break;
            }
            catch (ArtifactDeployerException e) {
                if (count + 1 < retryFailedDeploymentCount) {
                    this.getLog().warn("Encountered issue during deployment: " + e.getLocalizedMessage());
                    this.getLog().debug(e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected ArtifactRepository createDeploymentArtifactRepository(String id, String url) {
        return new MavenArtifactRepository(id, url, new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
    }

    private static class SimpleModelProblemCollector
    implements ModelProblemCollector {
        private final List<String> result;

        SimpleModelProblemCollector(List<String> result) {
            this.result = result;
        }

        @Override
        public void add(ModelProblemCollectorRequest req) {
            if (!ModelProblem.Severity.WARNING.equals((Object)req.getSeverity())) {
                this.result.add(req.getMessage());
            }
        }
    }
}

