/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.codehaus.plexus.util.cli.Commandline;

public class StaleHelper {
    public static List<String> getStaleData(Commandline cmd) throws MavenReportException {
        try {
            ArrayList<String> ignored = new ArrayList<String>();
            ArrayList<String> options = new ArrayList<String>();
            Path dir = cmd.getWorkingDirectory().toPath().toAbsolutePath().normalize();
            String[] args = cmd.getArguments();
            Collections.addAll(options, args);
            Charset cs = JavaVersion.JAVA_SPECIFICATION_VERSION.isAtLeast("9") && JavaVersion.JAVA_SPECIFICATION_VERSION.isBefore("12") ? StandardCharsets.UTF_8 : Charset.defaultCharset();
            for (String arg : args) {
                if (!arg.startsWith("@")) continue;
                String name = arg.substring(1);
                options.addAll(Files.readAllLines(dir.resolve(name), cs));
                ignored.add(name);
            }
            ArrayList<String> state = new ArrayList<String>(options);
            boolean cp = false;
            boolean sp = false;
            for (String arg : options) {
                Path p;
                String s2;
                if (cp) {
                    s2 = StaleHelper.unquote(arg);
                    for (String ps : s2.split(File.pathSeparator)) {
                        p = dir.resolve(ps);
                        state.add(p + " = " + StaleHelper.lastmod(p));
                    }
                } else if (sp) {
                    s2 = StaleHelper.unquote(arg);
                    for (String ps : s2.split(File.pathSeparator)) {
                        p = dir.resolve(ps);
                        for (Path c : StaleHelper.walk(p)) {
                            if (!Files.isRegularFile(c, new LinkOption[0])) continue;
                            state.add(c + " = " + StaleHelper.lastmod(c));
                        }
                        state.add(p + " = " + StaleHelper.lastmod(p));
                    }
                }
                cp = "-classpath".equals(arg);
                sp = "-sourcepath".equals(arg);
            }
            for (Path p : StaleHelper.walk(dir)) {
                if (!Files.isRegularFile(p, new LinkOption[0]) || ignored.contains(p.getFileName().toString())) continue;
                state.add(p + " = " + StaleHelper.lastmod(p));
            }
            return state;
        }
        catch (Exception e) {
            throw new MavenReportException("Unable to compute stale date", e);
        }
    }

    public static void writeStaleData(Commandline cmd, Path path) throws MavenReportException {
        try {
            List<String> curdata = StaleHelper.getStaleData(cmd);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, curdata, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MavenReportException("Error checking stale data", e);
        }
    }

    private static Collection<Path> walk(Path dir) {
        ArrayList<Path> arrayList;
        block9: {
            ArrayList<Path> paths = new ArrayList<Path>();
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);
            try {
                for (Path p : directoryStream) {
                    paths.add(p);
                }
                arrayList = paths;
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    private static String unquote(String s2) {
        if (s2.startsWith("'") && s2.endsWith("'")) {
            return s2.substring(1, s2.length() - 1).replaceAll("\\\\'", "'");
        }
        return s2;
    }

    private static long lastmod(Path p) {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

