/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractScmReleaseMojo;
import org.apache.maven.shared.release.DefaultReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseRollbackRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;

@Mojo(name="rollback", aggregator=true)
public class RollbackReleaseMojo
extends AbstractScmReleaseMojo {
    @Parameter(defaultValue="@{prefix} rollback the release of @{releaseLabel}", property="scmRollbackCommitComment")
    private String scmRollbackCommitComment = "@{prefix} rollback the release of @{releaseLabel}";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptorBuilder config = this.createReleaseDescriptor();
        config.setScmRollbackCommitComment(this.scmRollbackCommitComment);
        try {
            ReleaseRollbackRequest rollbackRequest = new ReleaseRollbackRequest();
            rollbackRequest.setReleaseDescriptorBuilder(config);
            rollbackRequest.setReleaseEnvironment(this.getReleaseEnvironment());
            rollbackRequest.setReactorProjects(this.getReactorProjects());
            rollbackRequest.setReleaseManagerListener(new DefaultReleaseManagerListener(this.getLog()));
            this.releaseManager.rollback(rollbackRequest);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
    }
}

