/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSourceJarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="maven.source.useDefaultExcludes", defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", readonly=false, required=true)
    private File defaultManifestFile;
    @Parameter(property="maven.source.useDefaultManifestFile", defaultValue="false")
    private boolean useDefaultManifestFile;
    @Parameter(property="maven.source.attach", defaultValue="true")
    private boolean attach;
    @Parameter(property="maven.source.excludeResources", defaultValue="false")
    protected boolean excludeResources;
    @Parameter(property="maven.source.includePom", defaultValue="false")
    protected boolean includePom;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    protected String finalName;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="maven.source.forceCreation", defaultValue="false")
    private boolean forceCreation;
    @Parameter(property="maven.source.skip", defaultValue="false")
    private boolean skipSource;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipSource) {
            this.getLog().info("Skipping source per configuration.");
            return;
        }
        this.packageSources(this.project);
    }

    protected abstract String getClassifier();

    protected abstract List<String> getSources(MavenProject var1) throws MojoExecutionException;

    protected abstract List<Resource> getResources(MavenProject var1) throws MojoExecutionException;

    protected void packageSources(MavenProject p) throws MojoExecutionException {
        if (!"pom".equals(p.getPackaging())) {
            this.packageSources(Collections.singletonList(p));
        }
    }

    protected void packageSources(List<MavenProject> theProjects) throws MojoExecutionException {
        if (this.project.getArtifact().getClassifier() != null) {
            this.getLog().warn("NOT adding sources to artifacts with classifier as Maven only supports one classifier per artifact. Current artifact [" + this.project.getArtifact().getId() + "] has a [" + this.project.getArtifact().getClassifier() + "] classifier.");
            return;
        }
        MavenArchiver archiver = this.createArchiver();
        for (MavenProject pItem : theProjects) {
            MavenProject subProject = this.getProject(pItem);
            if ("pom".equals(subProject.getPackaging())) continue;
            this.archiveProjectContent(subProject, archiver.getArchiver());
        }
        if (archiver.getArchiver().getResources().hasNext() || this.forceCreation) {
            if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath());
                this.archive.setManifestFile(this.defaultManifestFile);
            }
            File outputFile = new File(this.outputDirectory, this.finalName + "-" + this.getClassifier() + this.getExtension());
            try {
                archiver.setOutputFile(outputFile);
                this.archive.setForced(this.forceCreation);
                this.getLog().debug("create archive " + outputFile);
                archiver.createArchive(this.session, this.project, this.archive);
            }
            catch (IOException | DependencyResolutionRequiredException | ArchiverException | ManifestException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), e);
            }
            if (this.attach) {
                for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                    if (!this.isAlreadyAttached(attachedArtifact, this.project, this.getClassifier())) continue;
                    this.getLog().error("We have duplicated artifacts attached.");
                    throw new MojoExecutionException("Presumably you have configured maven-source-plugn to execute twice times in your build. You have to configure a classifier for at least on of them.");
                }
                this.projectHelper.attachArtifact(this.project, this.getType(), this.getClassifier(), outputFile);
            } else {
                this.getLog().info("NOT adding java-sources to attached artifacts list.");
            }
        } else {
            this.getLog().info("No sources in project. Archive not created.");
        }
    }

    private boolean isAlreadyAttached(Artifact artifact, MavenProject checkProject, String classifier) {
        return artifact.getType().equals(this.getType()) && artifact.getGroupId().equals(checkProject.getGroupId()) && artifact.getArtifactId().equals(checkProject.getArtifactId()) && artifact.getVersion().equals(checkProject.getVersion()) && artifact.getClassifier() != null && artifact.getClassifier().equals(classifier);
    }

    protected void archiveProjectContent(MavenProject p, Archiver archiver) throws MojoExecutionException {
        File sourceDirectory;
        if (this.includePom) {
            try {
                archiver.addFile(p.getFile(), p.getFile().getName());
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error adding POM file to target jar file.", e);
            }
        }
        for (String s2 : this.getSources(p)) {
            sourceDirectory = new File(s2);
            if (!sourceDirectory.exists()) continue;
            this.addDirectory(archiver, sourceDirectory, this.getCombinedIncludes(null), this.getCombinedExcludes(null));
        }
        for (Resource resource : this.getResources(p)) {
            sourceDirectory = new File(resource.getDirectory());
            if (!sourceDirectory.exists()) continue;
            List<String> resourceIncludes = resource.getIncludes();
            String[] combinedIncludes = this.getCombinedIncludes(resourceIncludes);
            List<String> resourceExcludes = resource.getExcludes();
            String[] combinedExcludes = this.getCombinedExcludes(resourceExcludes);
            String targetPath = resource.getTargetPath();
            if (targetPath != null) {
                if (!targetPath.trim().endsWith("/")) {
                    targetPath = targetPath + "/";
                }
                this.addDirectory(archiver, sourceDirectory, targetPath, combinedIncludes, combinedExcludes);
                continue;
            }
            this.addDirectory(archiver, sourceDirectory, combinedIncludes, combinedExcludes);
        }
    }

    protected MavenArchiver createArchiver() throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setCreatedBy("Maven Source Plugin", "org.apache.maven.plugins", "maven-source-plugin");
        archiver.setBuildJdkSpecDefaultEntry(false);
        archiver.configureReproducibleBuild(this.outputTimestamp);
        if (this.project.getBuild() != null) {
            List<Resource> resources = this.project.getBuild().getResources();
            for (Resource r : resources) {
                if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
                this.addDirectory(archiver.getArchiver(), new File(r.getDirectory()), this.getCombinedIncludes(null), this.getCombinedExcludes(null));
            }
        }
        return archiver;
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String[] pIncludes, String[] pExcludes) throws MojoExecutionException {
        try {
            this.getLog().debug("add directory " + sourceDirectory + " to archiver");
            archiver.addFileSet((FileSet)DefaultFileSet.fileSet(sourceDirectory).includeExclude(pIncludes, pExcludes));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", e);
        }
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String prefix, String[] pIncludes, String[] pExcludes) throws MojoExecutionException {
        try {
            this.getLog().debug("add directory " + sourceDirectory + " to archiver with prefix " + prefix);
            archiver.addFileSet((FileSet)((DefaultFileSet)DefaultFileSet.fileSet(sourceDirectory).prefixed(prefix)).includeExclude(pIncludes, pExcludes));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", e);
        }
    }

    protected String getExtension() {
        return ".jar";
    }

    protected MavenProject getProject(MavenProject p) {
        if (p.getExecutionProject() != null) {
            return p.getExecutionProject();
        }
        return p;
    }

    protected String getType() {
        return "java-source";
    }

    private String[] getCombinedIncludes(List<String> additionalIncludes) {
        ArrayList<String> combinedIncludes = new ArrayList<String>();
        if (this.includes != null && this.includes.length > 0) {
            combinedIncludes.addAll(Arrays.asList(this.includes));
        }
        if (additionalIncludes != null && !additionalIncludes.isEmpty()) {
            combinedIncludes.addAll(additionalIncludes);
        }
        if (combinedIncludes.isEmpty()) {
            combinedIncludes.addAll(Arrays.asList(DEFAULT_INCLUDES));
        }
        return combinedIncludes.toArray(new String[0]);
    }

    private String[] getCombinedExcludes(List<String> additionalExcludes) {
        ArrayList<String> combinedExcludes = new ArrayList<String>();
        if (this.useDefaultExcludes) {
            combinedExcludes.addAll(FileUtils.getDefaultExcludesAsList());
        }
        if (this.excludes != null && this.excludes.length > 0) {
            combinedExcludes.addAll(Arrays.asList(this.excludes));
        }
        if (additionalExcludes != null && !additionalExcludes.isEmpty()) {
            combinedExcludes.addAll(additionalExcludes);
        }
        if (combinedExcludes.isEmpty()) {
            combinedExcludes.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        return combinedExcludes.toArray(new String[0]);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void setProject(MavenProject project) {
        this.project = project;
    }
}

