/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectBuildingRequest
implements ProjectBuildingRequest {
    private RepositorySystemSession repositorySession;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginArtifactRepositories;
    private MavenProject project;
    private int validationLevel = 30;
    private boolean processPlugins = true;
    private List<Profile> profiles;
    private List<String> activeProfileIds;
    private List<String> inactiveProfileIds;
    private Properties systemProperties;
    private Properties userProperties;
    private Date buildStartTime;
    private boolean resolveDependencies;
    private ProjectBuildingRequest.RepositoryMerging repositoryMerging = ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT;

    public DefaultProjectBuildingRequest() {
        this.profiles = new ArrayList<Profile>();
        this.activeProfileIds = new ArrayList<String>();
        this.inactiveProfileIds = new ArrayList<String>();
        this.systemProperties = new Properties();
        this.userProperties = new Properties();
        this.remoteRepositories = new ArrayList<ArtifactRepository>();
        this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>();
    }

    public DefaultProjectBuildingRequest(ProjectBuildingRequest request) {
        this();
        this.setProcessPlugins(request.isProcessPlugins());
        this.setProfiles(request.getProfiles());
        this.setActiveProfileIds(request.getActiveProfileIds());
        this.setInactiveProfileIds(request.getInactiveProfileIds());
        this.setSystemProperties(request.getSystemProperties());
        this.setUserProperties(request.getUserProperties());
        this.setRemoteRepositories(request.getRemoteRepositories());
        this.setPluginArtifactRepositories(request.getPluginArtifactRepositories());
        this.setRepositorySession(request.getRepositorySession());
        this.setLocalRepository(request.getLocalRepository());
        this.setBuildStartTime(request.getBuildStartTime());
        this.setProject(request.getProject());
        this.setResolveDependencies(request.isResolveDependencies());
        this.setValidationLevel(request.getValidationLevel());
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    @Override
    public ProjectBuildingRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public ProjectBuildingRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        if (remoteRepositories != null) {
            this.remoteRepositories = new ArrayList<ArtifactRepository>(remoteRepositories);
        } else {
            this.remoteRepositories.clear();
        }
        return this;
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories() {
        return this.pluginArtifactRepositories;
    }

    @Override
    public ProjectBuildingRequest setPluginArtifactRepositories(List<ArtifactRepository> pluginArtifactRepositories) {
        if (pluginArtifactRepositories != null) {
            this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>(pluginArtifactRepositories);
        } else {
            this.pluginArtifactRepositories.clear();
        }
        return this;
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public ProjectBuildingRequest setSystemProperties(Properties systemProperties) {
        if (systemProperties != null) {
            this.systemProperties = new Properties();
            this.systemProperties.putAll((Map<?, ?>)systemProperties);
        } else {
            this.systemProperties.clear();
        }
        return this;
    }

    @Override
    public Properties getUserProperties() {
        return this.userProperties;
    }

    @Override
    public ProjectBuildingRequest setUserProperties(Properties userProperties) {
        if (userProperties != null) {
            this.userProperties = new Properties();
            this.userProperties.putAll((Map<?, ?>)userProperties);
        } else {
            this.userProperties.clear();
        }
        return this;
    }

    @Override
    public boolean isProcessPlugins() {
        return this.processPlugins;
    }

    @Override
    public ProjectBuildingRequest setProcessPlugins(boolean processPlugins) {
        this.processPlugins = processPlugins;
        return this;
    }

    @Override
    public ProjectBuildingRequest setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
        return this;
    }

    @Override
    public boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    @Override
    public ProjectBuildingRequest setValidationLevel(int validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    @Override
    public int getValidationLevel() {
        return this.validationLevel;
    }

    @Override
    public List<String> getActiveProfileIds() {
        return this.activeProfileIds;
    }

    @Override
    public void setActiveProfileIds(List<String> activeProfileIds) {
        if (activeProfileIds != null) {
            this.activeProfileIds = new ArrayList<String>(activeProfileIds);
        } else {
            this.activeProfileIds.clear();
        }
    }

    @Override
    public List<String> getInactiveProfileIds() {
        return this.inactiveProfileIds;
    }

    @Override
    public void setInactiveProfileIds(List<String> inactiveProfileIds) {
        if (inactiveProfileIds != null) {
            this.inactiveProfileIds = new ArrayList<String>(inactiveProfileIds);
        } else {
            this.inactiveProfileIds.clear();
        }
    }

    @Override
    public void setProfiles(List<Profile> profiles) {
        if (profiles != null) {
            this.profiles = new ArrayList<Profile>(profiles);
        } else {
            this.profiles.clear();
        }
    }

    @Override
    public void addProfile(Profile profile2) {
        this.profiles.add(profile2);
    }

    @Override
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @Override
    public Date getBuildStartTime() {
        return this.buildStartTime;
    }

    @Override
    public void setBuildStartTime(Date buildStartTime) {
        this.buildStartTime = buildStartTime;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        return this.repositorySession;
    }

    @Override
    public DefaultProjectBuildingRequest setRepositorySession(RepositorySystemSession repositorySession) {
        this.repositorySession = repositorySession;
        return this;
    }

    @Override
    public DefaultProjectBuildingRequest setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging repositoryMerging) {
        if (repositoryMerging == null) {
            throw new IllegalArgumentException("repository merge mode not specified");
        }
        this.repositoryMerging = repositoryMerging;
        return this;
    }

    @Override
    public ProjectBuildingRequest.RepositoryMerging getRepositoryMerging() {
        return this.repositoryMerging;
    }
}

