/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.info;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.StringUtils;

public class GitInfoConsumer
extends AbstractConsumer {
    private final List<InfoItem> infoItems = new ArrayList<InfoItem>(1);
    private final ScmFileSet scmFileSet;

    public GitInfoConsumer(ScmFileSet scmFileSet) {
        this.scmFileSet = scmFileSet;
    }

    @Override
    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("consume line " + line);
        }
        if (this.infoItems.isEmpty() && !StringUtils.isEmpty(line)) {
            InfoItem infoItem = new InfoItem();
            infoItem.setRevision(StringUtils.trim(line));
            infoItem.setURL(this.scmFileSet.getBasedir().toPath().toUri().toASCIIString());
            this.infoItems.add(infoItem);
        }
    }

    public List<InfoItem> getInfoItems() {
        return this.infoItems;
    }
}

