/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.status;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.StringUtils;

public class GitStatusConsumer
extends AbstractConsumer {
    private static final Pattern ADDED_PATTERN = Pattern.compile("^A[ M]* (.*)$");
    private static final Pattern MODIFIED_PATTERN = Pattern.compile("^ *M[ M]* (.*)$");
    private static final Pattern DELETED_PATTERN = Pattern.compile("^ *D * (.*)$");
    private static final Pattern RENAMED_PATTERN = Pattern.compile("^R  (.*) -> (.*)$");
    private final File workingDirectory;
    private ScmFileSet scmFileSet;
    private final List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private URI relativeRepositoryPath;

    public GitStatusConsumer(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public GitStatusConsumer(File workingDirectory, URI relativeRepositoryPath) {
        this(workingDirectory);
        this.relativeRepositoryPath = relativeRepositoryPath;
    }

    public GitStatusConsumer(File workingDirectory, ScmFileSet scmFileSet) {
        this(workingDirectory);
        this.scmFileSet = scmFileSet;
    }

    public GitStatusConsumer(File workingDirectory, URI relativeRepositoryPath, ScmFileSet scmFileSet) {
        this(workingDirectory, scmFileSet);
        this.relativeRepositoryPath = relativeRepositoryPath;
    }

    @Override
    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (StringUtils.isEmpty(line)) {
            return;
        }
        ScmFileStatus status = null;
        ArrayList<String> files = new ArrayList<String>();
        Matcher matcher = ADDED_PATTERN.matcher(line);
        if (matcher.find()) {
            status = ScmFileStatus.ADDED;
            files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
        } else {
            matcher = MODIFIED_PATTERN.matcher(line);
            if (matcher.find()) {
                status = ScmFileStatus.MODIFIED;
                files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
            } else {
                matcher = DELETED_PATTERN.matcher(line);
                if (matcher.find()) {
                    status = ScmFileStatus.DELETED;
                    files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
                } else {
                    matcher = RENAMED_PATTERN.matcher(line);
                    if (matcher.find()) {
                        status = ScmFileStatus.RENAMED;
                        files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
                        files.add(GitStatusConsumer.resolvePath(matcher.group(2), this.relativeRepositoryPath));
                        this.logger.debug("RENAMED status for line '" + line + "' files added '" + matcher.group(1) + "' '" + matcher.group(2));
                    } else {
                        this.logger.warn("Ignoring unrecognized line: " + line);
                        return;
                    }
                }
            }
        }
        if (!files.isEmpty()) {
            if (this.workingDirectory != null) {
                if (status == ScmFileStatus.RENAMED) {
                    String oldFilePath = (String)files.get(0);
                    String newFilePath = (String)files.get(1);
                    if (this.isFile(oldFilePath)) {
                        this.logger.debug("file '" + oldFilePath + "' is a file");
                        return;
                    }
                    this.logger.debug("file '" + oldFilePath + "' not a file");
                    if (!this.isFile(newFilePath)) {
                        this.logger.debug("file '" + newFilePath + "' not a file");
                        return;
                    }
                    this.logger.debug("file '" + newFilePath + "' is a file");
                } else if (status == ScmFileStatus.DELETED ? this.isFile((String)files.get(0)) : !this.isFile((String)files.get(0))) {
                    return;
                }
            }
            for (String file : files) {
                if (this.scmFileSet != null && !this.isFileNameInFileList(this.scmFileSet.getFileList(), file)) continue;
                this.changedFiles.add(new ScmFile(file, status));
            }
        }
    }

    private boolean isFileNameInFileList(List<File> fileList, String fileName) {
        if (this.relativeRepositoryPath == null) {
            return fileList.contains(new File(fileName));
        }
        for (File f : fileList) {
            File file = new File(this.relativeRepositoryPath.getPath(), fileName);
            if (!file.getPath().endsWith(f.getName())) continue;
            return true;
        }
        return fileList.isEmpty();
    }

    private boolean isFile(String file) {
        File targetFile = new File(this.workingDirectory, file);
        return targetFile.isFile();
    }

    public static String resolvePath(String fileEntry, URI path) {
        String cleanedEntry = GitStatusConsumer.stripQuotes(fileEntry);
        if (path != null) {
            return GitStatusConsumer.resolveURI(cleanedEntry, path).getPath();
        }
        return cleanedEntry;
    }

    public static URI resolveURI(String fileEntry, URI path) {
        return path.relativize(GitStatusConsumer.uriFromPath(GitStatusConsumer.stripQuotes(fileEntry)));
    }

    public static URI uriFromPath(String path) {
        try {
            if (path != null && path.indexOf(58) != -1) {
                String tmp = new URI(null, null, "/x" + path, null).toString().substring(2);
                return new URI(tmp.replace(":", "%3A"));
            }
            return new URI(null, null, path, null);
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }

    private static String stripQuotes(String str) {
        int strLen = str.length();
        return strLen > 0 && str.startsWith("\"") && str.endsWith("\"") ? GitStatusConsumer.unescape(str.substring(1, strLen - 1)) : str;
    }

    private static String unescape(String fileEntry) {
        int pos = fileEntry.indexOf(92);
        if (pos == -1) {
            return fileEntry;
        }
        byte[] inba = fileEntry.getBytes();
        int inSub = 0;
        byte[] outba = new byte[fileEntry.length()];
        int outSub = 0;
        do {
            System.arraycopy(inba, inSub, outba, outSub, pos - inSub);
            outSub += pos - inSub;
            inSub = pos + 1;
            switch ((char)inba[inSub++]) {
                case '\"': {
                    outba[outSub++] = 34;
                    break;
                }
                case 'a': {
                    outba[outSub++] = 7;
                    break;
                }
                case 'b': {
                    outba[outSub++] = 8;
                    break;
                }
                case 't': {
                    outba[outSub++] = 9;
                    break;
                }
                case 'n': {
                    outba[outSub++] = 10;
                    break;
                }
                case 'v': {
                    outba[outSub++] = 11;
                    break;
                }
                case 'f': {
                    outba[outSub++] = 12;
                    break;
                }
                case 'r': {
                    outba[outSub++] = 12;
                    break;
                }
                case '\\': {
                    outba[outSub++] = 92;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    byte b = (byte)(inba[inSub - 1] - 48 << 6);
                    b = (byte)(b | (byte)(inba[inSub++] - 48 << 3));
                    b = (byte)(b | (byte)(inba[inSub++] - 48));
                    outba[outSub++] = b;
                    break;
                }
                default: {
                    outba[outSub++] = 92;
                    --inSub;
                }
            }
        } while ((pos = fileEntry.indexOf(92, inSub)) != -1);
        System.arraycopy(inba, inSub, outba, outSub, inba.length - inSub);
        outSub += inba.length - inSub;
        try {
            return new String(outba, 0, outSub, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

