/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.git.AbstractGitScmProvider;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.PlexusInteractivityCredentialsProvider;
import org.apache.maven.scm.provider.git.jgit.command.add.JGitAddCommand;
import org.apache.maven.scm.provider.git.jgit.command.blame.JGitBlameCommand;
import org.apache.maven.scm.provider.git.jgit.command.branch.JGitBranchCommand;
import org.apache.maven.scm.provider.git.jgit.command.changelog.JGitChangeLogCommand;
import org.apache.maven.scm.provider.git.jgit.command.checkin.JGitCheckInCommand;
import org.apache.maven.scm.provider.git.jgit.command.checkout.JGitCheckOutCommand;
import org.apache.maven.scm.provider.git.jgit.command.diff.JGitDiffCommand;
import org.apache.maven.scm.provider.git.jgit.command.info.JGitInfoCommand;
import org.apache.maven.scm.provider.git.jgit.command.list.JGitListCommand;
import org.apache.maven.scm.provider.git.jgit.command.remoteinfo.JGitRemoteInfoCommand;
import org.apache.maven.scm.provider.git.jgit.command.remove.JGitRemoveCommand;
import org.apache.maven.scm.provider.git.jgit.command.status.JGitStatusCommand;
import org.apache.maven.scm.provider.git.jgit.command.tag.JGitTagCommand;
import org.apache.maven.scm.provider.git.jgit.command.untag.JGitUntagCommand;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.eclipse.jgit.transport.CredentialsProvider;

@Singleton
@Named(value="jgit")
public class JGitScmProvider
extends AbstractGitScmProvider {
    private final PlexusInteractivityCredentialsProvider credentialsProvider;

    @Inject
    public JGitScmProvider(Prompter prompter) {
        this.credentialsProvider = new PlexusInteractivityCredentialsProvider(prompter);
        CredentialsProvider.setDefault(this.credentialsProvider);
    }

    @Override
    public void setInteractive(boolean interactive) {
        this.credentialsProvider.setInteractive(interactive);
    }

    @Override
    protected GitCommand getAddCommand() {
        return new JGitAddCommand();
    }

    @Override
    protected GitCommand getBranchCommand() {
        return new JGitBranchCommand();
    }

    @Override
    protected GitCommand getChangeLogCommand() {
        return new JGitChangeLogCommand();
    }

    @Override
    protected GitCommand getCheckInCommand() {
        return new JGitCheckInCommand();
    }

    @Override
    protected GitCommand getCheckOutCommand() {
        return new JGitCheckOutCommand();
    }

    @Override
    protected GitCommand getDiffCommand() {
        return new JGitDiffCommand();
    }

    @Override
    protected GitCommand getExportCommand() {
        throw new UnsupportedOperationException("getExportCommand");
    }

    @Override
    protected GitCommand getRemoveCommand() {
        return new JGitRemoveCommand();
    }

    @Override
    protected GitCommand getStatusCommand() {
        return new JGitStatusCommand();
    }

    @Override
    protected GitCommand getTagCommand() {
        return new JGitTagCommand();
    }

    @Override
    protected GitCommand getUntagCommand() {
        return new JGitUntagCommand();
    }

    @Override
    protected GitCommand getUpdateCommand() {
        throw new UnsupportedOperationException("getUpdateCommand");
    }

    protected GitCommand getListCommand() {
        return new JGitListCommand();
    }

    @Override
    public GitCommand getInfoCommand() {
        return new JGitInfoCommand();
    }

    @Override
    protected String getRepositoryURL(File path) throws ScmException {
        InfoScmResult result = this.info(null, new ScmFileSet(new File(""), path), null);
        if (result.getInfoItems().size() != 1) {
            throw new ScmRepositoryException("Cannot find URL: " + (result.getInfoItems().size() == 0 ? "no" : "multiple") + " items returned by the info command");
        }
        return result.getInfoItems().get(0).getURL();
    }

    @Override
    protected GitCommand getBlameCommand() {
        return new JGitBlameCommand();
    }

    @Override
    protected GitCommand getRemoteInfoCommand() {
        return new JGitRemoteInfoCommand();
    }
}

