/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command;

import java.util.Arrays;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class PlexusInteractivityCredentialsProvider
extends CredentialsProvider {
    private boolean interactive = true;
    private final Prompter prompter;

    public PlexusInteractivityCredentialsProvider(Prompter prompter) {
        this.prompter = prompter;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) {
        for (CredentialItem item : items) {
            try {
                this.get(uri, item);
            }
            catch (PrompterException e) {
                throw new IllegalStateException("Cannot prompt user", e);
            }
        }
        return true;
    }

    private void get(URIish uri, CredentialItem item) throws PrompterException {
        if (item instanceof CredentialItem.InformationalMessage) {
            this.prompter.showMessage(item.getPromptText());
        } else {
            if (!this.interactive) {
                throw new UnsupportedCredentialItem(uri, "Cannot provide '" + item.getClass() + "' in non-interactive mode");
            }
            if (item instanceof CredentialItem.YesNoType) {
                CredentialItem.YesNoType yesNoItem = (CredentialItem.YesNoType)item;
                String value = this.prompter.prompt(item.getPromptText(), Arrays.asList("yes", "no"));
                yesNoItem.setValue(value.equals("yes"));
            } else if (item instanceof CredentialItem.Password) {
                CredentialItem.Password passwordItem = (CredentialItem.Password)item;
                String password = this.prompter.promptForPassword(passwordItem.getPromptText());
                passwordItem.setValue(password.toCharArray());
            } else if (item instanceof CredentialItem.Username) {
                CredentialItem.Username usernameItem = (CredentialItem.Username)item;
                String username = this.prompter.prompt(usernameItem.getPromptText());
                usernameItem.setValue(username);
            } else if (item instanceof CredentialItem.StringType) {
                CredentialItem.StringType stringItem = (CredentialItem.StringType)item;
                String value = this.prompter.prompt(stringItem.getPromptText());
                stringItem.setValue(value);
            } else if (item instanceof CredentialItem.CharArrayType) {
                CredentialItem.CharArrayType charArrayItem = (CredentialItem.CharArrayType)item;
                String value = this.prompter.prompt(charArrayItem.getPromptText());
                charArrayItem.setValue(value.toCharArray());
            } else {
                throw new UnsupportedCredentialItem(uri, "This provider does not support items of type '" + item.getClass() + "'");
            }
        }
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        return true;
    }
}

