/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.diff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.command.diff.GitDiffConsumer;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;

public class JGitDiffCommand
extends AbstractDiffCommand
implements GitCommand {
    @Override
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startRevision, ScmVersion endRevision) throws ScmException {
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            DiffScmResult diff = this.callDiff(git, startRevision, endRevision);
            git.getRepository().close();
            DiffScmResult diffScmResult = diff;
            return diffScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit diff failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }

    public DiffScmResult callDiff(Git git, ScmVersion startRevision, ScmVersion endRevision) throws IOException, GitAPIException, ScmException {
        String[] lines;
        AbstractTreeIterator oldTree = null;
        if (startRevision != null && StringUtils.isNotEmpty(startRevision.getName().trim())) {
            String startRev = startRevision.getName().trim();
            oldTree = this.getTreeIterator(git.getRepository(), startRev);
        }
        AbstractTreeIterator newTree = null;
        if (endRevision != null && StringUtils.isNotEmpty(endRevision.getName().trim())) {
            String endRev = endRevision.getName().trim();
            newTree = this.getTreeIterator(git.getRepository(), endRev);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        git.diff().setOutputStream(out).setOldTree(oldTree).setNewTree(newTree).setCached(false).call();
        git.diff().setOutputStream(out).setOldTree(oldTree).setNewTree(newTree).setCached(true).call();
        out.flush();
        GitDiffConsumer consumer = new GitDiffConsumer(null);
        String fullDiff = ((Object)out).toString();
        ((OutputStream)out).close();
        for (String aLine : lines = fullDiff.split("\n")) {
            consumer.consumeLine(aLine);
        }
        return new DiffScmResult("JGit diff", consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
    }

    /*
     * Exception decompiling
     */
    private AbstractTreeIterator getTreeIterator(Repository repo, String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

