/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.list;

import java.util.ArrayList;
import java.util.function.BiFunction;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;

public class JGitListCommand
extends AbstractListCommand
implements GitCommand {
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    @Override
    protected ListScmResult executeListCommand(ScmProviderRepository repo, ScmFileSet fileSet, boolean recursive, ScmVersion scmVersion) throws ScmException {
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            CredentialsProvider credentials = JGitUtils.prepareSession(git, (GitScmProviderRepository)repo);
            ArrayList<ScmFile> list = new ArrayList<ScmFile>();
            Object lsResult = ((LsRemoteCommand)((LsRemoteCommand)git.lsRemote().setCredentialsProvider(credentials)).setTransportConfigCallback(new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply((GitScmProviderRepository)repo, this.logger)))).call();
            Object object = lsResult.iterator();
            while (object.hasNext()) {
                Ref ref = (Ref)object.next();
                this.logger.debug(ref.getObjectId().getName() + "  " + ref.getTarget().getName());
                list.add(new ScmFile(ref.getName(), ScmFileStatus.CHECKED_IN));
            }
            object = new ListScmResult("JGit ls-remote", list);
            return object;
        }
        catch (Exception e) {
            throw new ScmException("JGit ls-remote failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

