/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.remoteinfo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.remoteinfo.AbstractRemoteInfoCommand;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;

public class JGitRemoteInfoCommand
extends AbstractRemoteInfoCommand
implements GitCommand {
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    @Override
    public RemoteInfoScmResult executeRemoteInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitScmProviderRepository repo = (GitScmProviderRepository)repository;
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            CredentialsProvider credentials = JGitUtils.getCredentials(repo);
            LsRemoteCommand lsCommand = (LsRemoteCommand)((LsRemoteCommand)git.lsRemote().setRemote(repo.getPushUrl()).setCredentialsProvider(credentials)).setTransportConfigCallback(new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply(repo, this.logger)));
            HashMap<String, String> tag = new HashMap<String, String>();
            Object allTags = lsCommand.setHeads(false).setTags(true).call();
            Iterator iterator = allTags.iterator();
            while (iterator.hasNext()) {
                Ref ref = (Ref)iterator.next();
                tag.put(Repository.shortenRefName(ref.getName()), ref.getObjectId().name());
            }
            HashMap<String, String> heads = new HashMap<String, String>();
            Object allHeads = lsCommand.setHeads(true).setTags(false).call();
            Object object = allHeads.iterator();
            while (object.hasNext()) {
                Ref ref = (Ref)object.next();
                heads.put(Repository.shortenRefName(ref.getName()), ref.getObjectId().name());
            }
            object = new RemoteInfoScmResult("JGit remoteinfo", heads, tag);
            return object;
        }
        catch (Exception e) {
            throw new ScmException("JGit remoteinfo failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

