/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.remove;

import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.eclipse.jgit.api.Git;

public class JGitRemoveCommand
extends AbstractRemoveCommand
implements GitCommand {
    @Override
    protected ScmResult executeRemoveCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to remove");
        }
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            List<ScmFile> removedFiles = JGitUtils.removeAllFiles(git, fileSet);
            if (this.logger.isDebugEnabled()) {
                for (ScmFile scmFile : removedFiles) {
                    this.logger.info("Removed file: " + scmFile);
                }
            }
            RemoveScmResult removeScmResult = new RemoveScmResult("JGit remove", removedFiles);
            return removeScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit remove failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

