/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;

public class JGitStatusCommand
extends AbstractStatusCommand
implements GitCommand {
    @Override
    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            Status status = git.status().call();
            List<ScmFile> changedFiles = this.getFileStati(status);
            StatusScmResult statusScmResult = new StatusScmResult("JGit status", changedFiles);
            return statusScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit status failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }

    private List<ScmFile> getFileStati(Status status) {
        ArrayList<ScmFile> all = new ArrayList<ScmFile>();
        this.addAsScmFiles(all, status.getAdded(), ScmFileStatus.ADDED);
        this.addAsScmFiles(all, status.getChanged(), ScmFileStatus.UPDATED);
        this.addAsScmFiles(all, status.getConflicting(), ScmFileStatus.CONFLICT);
        this.addAsScmFiles(all, status.getModified(), ScmFileStatus.MODIFIED);
        this.addAsScmFiles(all, status.getRemoved(), ScmFileStatus.DELETED);
        return all;
    }

    private void addAsScmFiles(Collection<ScmFile> all, Collection<String> files, ScmFileStatus status) {
        for (String f : files) {
            all.add(new ScmFile(f, status));
        }
    }
}

