/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.svn.svnexe.command.AbstractFileCheckingConsumer;
import org.codehaus.plexus.util.StringUtils;

public class SvnCheckOutConsumer
extends AbstractFileCheckingConsumer {
    private static final String CHECKED_OUT_REVISION_TOKEN = "Checked out revision";
    private final List<ScmFile> files = new ArrayList<ScmFile>();

    public SvnCheckOutConsumer(File workingDirectory) {
        super(workingDirectory);
    }

    @Override
    protected void parseLine(String line) {
        ScmFileStatus status;
        String statusString = line.substring(0, 1);
        String file = line.substring(3).trim();
        if (file.startsWith(this.getWorkingDirectory().getAbsolutePath())) {
            file = StringUtils.substring(file, this.getWorkingDirectory().getAbsolutePath().length() + 1);
        }
        if (line.startsWith(CHECKED_OUT_REVISION_TOKEN)) {
            String revisionString = line.substring(CHECKED_OUT_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("U")) {
            status = ScmFileStatus.UPDATED;
        } else {
            return;
        }
        this.addFile(new ScmFile(file, status));
    }

    public List<ScmFile> getCheckedOutFiles() {
        return this.getFiles();
    }

    @Override
    protected void addFile(ScmFile file) {
        this.files.add(file);
    }

    @Override
    protected List<ScmFile> getFiles() {
        ArrayList<ScmFile> onlyFiles = new ArrayList<ScmFile>();
        for (ScmFile file : this.files) {
            if (!file.getStatus().equals(ScmFileStatus.DELETED) && !new File(this.getWorkingDirectory(), file.getPath()).isFile() && !file.getStatus().equals(ScmFileStatus.DELETED) && !new File(this.getWorkingDirectory().getParent(), file.getPath()).isFile()) continue;
            onlyFiles.add(file);
        }
        return onlyFiles;
    }
}

