/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.info;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.util.AbstractConsumer;

public class SvnInfoConsumer
extends AbstractConsumer {
    private final List<InfoItem> infoItems = new ArrayList<InfoItem>();
    private InfoItem currentItem = new InfoItem();

    @Override
    public void consumeLine(String s2) {
        if (s2.equals("")) {
            if (this.currentItem != null) {
                this.infoItems.add(this.currentItem);
            }
            this.currentItem = new InfoItem();
        } else if (s2.startsWith("Path: ")) {
            this.currentItem.setPath(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("URL: ")) {
            this.currentItem.setURL(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Repository Root: ")) {
            this.currentItem.setRepositoryRoot(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Repository UUID: ")) {
            this.currentItem.setRepositoryUUID(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Revision: ")) {
            this.currentItem.setRevision(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Node Kind: ")) {
            this.currentItem.setNodeKind(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Schedule: ")) {
            this.currentItem.setSchedule(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Last Changed Author: ")) {
            this.currentItem.setLastChangedAuthor(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Last Changed Rev: ")) {
            this.currentItem.setLastChangedRevision(SvnInfoConsumer.getValue(s2));
        } else if (s2.startsWith("Last Changed Date: ")) {
            this.currentItem.setLastChangedDate(SvnInfoConsumer.getValue(s2));
        }
    }

    private static String getValue(String s2) {
        int idx = s2.indexOf(": ");
        if (idx < 0) {
            return null;
        }
        return s2.substring(idx + 2);
    }

    public List<InfoItem> getInfoItems() {
        return this.infoItems;
    }
}

