/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.eclipse.aether.graph.Dependency;

public class ArtifactTransitivityFilter
extends AbstractArtifactsFilter {
    private Set<String> transitiveArtifacts;

    public ArtifactTransitivityFilter(Artifact artifact, ProjectBuildingRequest buildingRequest, ProjectBuilder projectBuilder) throws ProjectBuildingException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(buildingRequest);
        request.setResolveDependencies(true);
        ProjectBuildingResult buildingResult = projectBuilder.build(artifact, (ProjectBuildingRequest)request);
        DependencyResolutionResult resolutionResult = buildingResult.getDependencyResolutionResult();
        if (resolutionResult != null) {
            for (Dependency dependency : resolutionResult.getDependencies()) {
                Artifact mavenArtifact = RepositoryUtils.toArtifact(dependency.getArtifact());
                this.transitiveArtifacts.add(mavenArtifact.getDependencyConflictId());
            }
        }
    }

    @Override
    public Set<Artifact> filter(Set<Artifact> artifacts) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.artifactIsATransitiveDependency(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean artifactIsATransitiveDependency(Artifact artifact) {
        return this.transitiveArtifacts.contains(artifact.getDependencyConflictId());
    }
}

