/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release;

import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultReleaseManagerListener
implements ReleaseManagerListener {
    private final Log log;
    private final boolean dryRun;
    private String goal;
    private List<String> phases;
    private int currentPhase;

    public DefaultReleaseManagerListener(Log log) {
        this(log, false);
    }

    public DefaultReleaseManagerListener(Log log, boolean dryRun) {
        this.log = log;
        this.dryRun = dryRun;
    }

    private void nextPhase(String name) {
        ++this.currentPhase;
        if (!name.equals(this.phases.get(this.currentPhase))) {
            this.log.warn("inconsistent phase name: expected '" + this.phases.get(this.currentPhase) + "' but got '" + name + "'");
        }
    }

    @Override
    public void goalStart(String goal, List<String> phases) {
        this.log.info("starting " + MessageUtils.buffer().mojo(goal) + " goal" + (this.dryRun ? " in dry-run mode" : "") + ", composed of " + phases.size() + " phases: " + StringUtils.join(phases.iterator(), ", "));
        this.currentPhase = -1;
        this.phases = phases;
        this.goal = goal;
    }

    @Override
    public void phaseStart(String name) {
        this.nextPhase(name);
        this.log.info(this.currentPhase + 1 + "/" + this.phases.size() + ' ' + MessageUtils.buffer().mojo(this.goal + ':' + name) + (this.dryRun ? " dry-run" : ""));
    }

    @Override
    public void phaseEnd() {
    }

    @Override
    public void phaseSkip(String name) {
        this.nextPhase(name);
    }

    @Override
    public void goalEnd() {
        this.goal = null;
        this.phases = null;
    }

    @Override
    public void error(String reason) {
        this.log.error("error during phase " + (this.currentPhase + 1) + "/" + this.phases.size() + " " + this.phases.get(this.currentPhase) + ": " + reason);
    }
}

