/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.util.MavenCrypto;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenExecutor
implements MavenExecutor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MavenCrypto mavenCrypto;

    protected AbstractMavenExecutor(MavenCrypto mavenCrypto) {
        this.mavenCrypto = Objects.requireNonNull(mavenCrypto);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        ArrayList<String> goalsList = new ArrayList<String>();
        if (goals != null) {
            Collections.addAll(goalsList, StringUtils.split(goals, ", \n\r\t"));
        }
        this.executeGoals(workingDirectory, goalsList, releaseEnvironment, interactive, additionalArguments, pomFileName, result);
    }

    protected abstract void executeGoals(File var1, List<String> var2, ReleaseEnvironment var3, boolean var4, String var5, String var6, ReleaseResult var7) throws MavenExecutorException;

    protected final Logger getLogger() {
        return this.logger;
    }

    protected Settings encryptSettings(Settings settings) {
        String password;
        Settings encryptedSettings = SettingsUtils.copySettings(settings);
        for (Server server : encryptedSettings.getServers()) {
            String passphrase;
            password = server.getPassword();
            if (password != null && !this.mavenCrypto.isEncryptedString(password)) {
                try {
                    server.setPassword(this.mavenCrypto.encryptAndDecorate(password));
                }
                catch (MavenCrypto.MavenCryptoException mavenCryptoException) {
                    // empty catch block
                }
            }
            if ((passphrase = server.getPassphrase()) == null || this.mavenCrypto.isEncryptedString(passphrase)) continue;
            try {
                server.setPassphrase(this.mavenCrypto.encryptAndDecorate(passphrase));
            }
            catch (MavenCrypto.MavenCryptoException mavenCryptoException) {}
        }
        for (Proxy proxy : encryptedSettings.getProxies()) {
            password = proxy.getPassword();
            if (password == null || this.mavenCrypto.isEncryptedString(password)) continue;
            try {
                proxy.setPassword(this.mavenCrypto.encryptAndDecorate(password));
            }
            catch (MavenCrypto.MavenCryptoException mavenCryptoException) {}
        }
        return encryptedSettings;
    }

    protected SettingsXpp3Writer getSettingsWriter() {
        return new SettingsXpp3Writer();
    }
}

