/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@Singleton
@Named(value="check-dependency-snapshots")
public class CheckDependencySnapshotsPhase
extends AbstractReleasePhase {
    public static final String RESOLVE_SNAPSHOT_MESSAGE = "There are still some remaining snapshot dependencies.\n";
    public static final String RESOLVE_SNAPSHOT_PROMPT = "Do you want to resolve them now?";
    public static final String RESOLVE_SNAPSHOT_TYPE_MESSAGE = "Dependency type to resolve,";
    public static final String RESOLVE_SNAPSHOT_TYPE_PROMPT = "specify the selection number ( 0:All 1:Project Dependencies 2:Plugins 3:Reports 4:Extensions ):";
    private final AtomicReference<Prompter> prompter;
    private String resolveSnapshot;
    private String resolveSnapshotType;

    @Inject
    public CheckDependencySnapshotsPhase(Prompter prompter) {
        this.prompter = new AtomicReference<Prompter>(Objects.requireNonNull(prompter));
    }

    public void setPrompter(Prompter prompter) {
        this.prompter.set(prompter);
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (!releaseDescriptor.isAllowTimestampedSnapshots()) {
            this.logInfo(result, "Checking dependencies and plugins for snapshots ...");
            for (MavenProject project : reactorProjects) {
                this.checkProject(project, releaseDescriptor);
            }
        } else {
            this.logInfo(result, "Ignoring SNAPSHOT dependencies and plugins ...");
        }
        result.setResultCode(0);
        return result;
    }

    private void checkProject(MavenProject project, ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException, ReleaseExecutionException {
        Map<String, Artifact> artifactMap = ArtifactUtils.artifactMapByVersionlessId(project.getArtifacts());
        HashSet<Artifact> usedSnapshotDependencies = new HashSet<Artifact>();
        if (project.getParentArtifact() != null && CheckDependencySnapshotsPhase.checkArtifact(project.getParentArtifact(), artifactMap, releaseDescriptor)) {
            usedSnapshotDependencies.add(project.getParentArtifact());
        }
        Set<Artifact> dependencyArtifacts = project.getDependencyArtifacts();
        usedSnapshotDependencies.addAll(this.checkDependencies(releaseDescriptor, artifactMap, dependencyArtifacts));
        Set<Artifact> pluginArtifacts = project.getPluginArtifacts();
        Set<Artifact> usedSnapshotPlugins = this.checkPlugins(releaseDescriptor, artifactMap, pluginArtifacts);
        Set<Artifact> reportArtifacts = project.getReportArtifacts();
        Set<Artifact> usedSnapshotReports = this.checkReports(releaseDescriptor, artifactMap, reportArtifacts);
        Set<Artifact> extensionArtifacts = project.getExtensionArtifacts();
        Set<Artifact> usedSnapshotExtensions = this.checkExtensions(releaseDescriptor, artifactMap, extensionArtifacts);
        if (!(usedSnapshotDependencies.isEmpty() && usedSnapshotReports.isEmpty() && usedSnapshotExtensions.isEmpty() && usedSnapshotPlugins.isEmpty())) {
            if (releaseDescriptor.isInteractive() || null != releaseDescriptor.getAutoResolveSnapshots()) {
                this.resolveSnapshots(usedSnapshotDependencies, usedSnapshotReports, usedSnapshotExtensions, usedSnapshotPlugins, releaseDescriptor);
            }
            if (!(usedSnapshotDependencies.isEmpty() && usedSnapshotReports.isEmpty() && usedSnapshotExtensions.isEmpty() && usedSnapshotPlugins.isEmpty())) {
                StringBuilder message = new StringBuilder();
                this.printSnapshotDependencies(usedSnapshotDependencies, message);
                this.printSnapshotDependencies(usedSnapshotReports, message);
                this.printSnapshotDependencies(usedSnapshotExtensions, message);
                this.printSnapshotDependencies(usedSnapshotPlugins, message);
                message.append("in project '" + project.getName() + "' (" + project.getId() + ")");
                throw new ReleaseFailureException("Can't release project due to non released dependencies :\n" + message);
            }
        }
    }

    private Set<Artifact> checkPlugins(ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> pluginArtifacts) throws ReleaseExecutionException {
        HashSet<Artifact> usedSnapshotPlugins = new HashSet<Artifact>();
        for (Artifact artifact : pluginArtifacts) {
            boolean addToFailures;
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, artifactMap, releaseDescriptor)) continue;
            if ("org.apache.maven.plugins".equals(artifact.getGroupId()) && "maven-release-plugin".equals(artifact.getArtifactId())) {
                if (releaseDescriptor.isSnapshotReleasePluginAllowed()) {
                    addToFailures = false;
                } else if (releaseDescriptor.isInteractive()) {
                    try {
                        String result;
                        if (!releaseDescriptor.isSnapshotReleasePluginAllowed()) {
                            this.prompter.get().showMessage("This project relies on a SNAPSHOT of the release plugin. This may be necessary during testing.\n");
                            result = this.prompter.get().prompt("Do you want to continue with the release?", Arrays.asList("yes", "no"), "no");
                        } else {
                            result = "yes";
                        }
                        addToFailures = !result.toLowerCase(Locale.ENGLISH).startsWith("y");
                    }
                    catch (PrompterException e) {
                        throw new ReleaseExecutionException(e.getMessage(), e);
                    }
                } else {
                    addToFailures = true;
                }
            } else {
                addToFailures = true;
            }
            if (!addToFailures) continue;
            usedSnapshotPlugins.add(artifact);
        }
        return usedSnapshotPlugins;
    }

    private Set<Artifact> checkDependencies(ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> dependencyArtifacts) {
        HashSet<Artifact> usedSnapshotDependencies = new HashSet<Artifact>();
        for (Artifact artifact : dependencyArtifacts) {
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, artifactMap, releaseDescriptor)) continue;
            usedSnapshotDependencies.add(CheckDependencySnapshotsPhase.getArtifactFromMap(artifact, artifactMap));
        }
        return usedSnapshotDependencies;
    }

    private Set<Artifact> checkReports(ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> reportArtifacts) {
        HashSet<Artifact> usedSnapshotReports = new HashSet<Artifact>();
        for (Artifact artifact : reportArtifacts) {
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, artifactMap, releaseDescriptor)) continue;
            usedSnapshotReports.add(artifact);
        }
        return usedSnapshotReports;
    }

    private Set<Artifact> checkExtensions(ReleaseDescriptor releaseDescriptor, Map<String, Artifact> artifactMap, Set<Artifact> extensionArtifacts) {
        HashSet<Artifact> usedSnapshotExtensions = new HashSet<Artifact>();
        for (Artifact artifact : extensionArtifacts) {
            if (!CheckDependencySnapshotsPhase.checkArtifact(artifact, artifactMap, releaseDescriptor)) continue;
            usedSnapshotExtensions.add(artifact);
        }
        return usedSnapshotExtensions;
    }

    private static boolean checkArtifact(Artifact artifact, Map<String, Artifact> artifactMapByVersionlessId, ReleaseDescriptor releaseDescriptor) {
        Artifact checkArtifact = CheckDependencySnapshotsPhase.getArtifactFromMap(artifact, artifactMapByVersionlessId);
        return CheckDependencySnapshotsPhase.checkArtifact(checkArtifact, releaseDescriptor);
    }

    private static Artifact getArtifactFromMap(Artifact artifact, Map<String, Artifact> artifactMapByVersionlessId) {
        String versionlessId = ArtifactUtils.versionlessKey(artifact);
        Artifact checkArtifact = artifactMapByVersionlessId.get(versionlessId);
        if (checkArtifact == null) {
            checkArtifact = artifact;
        }
        return checkArtifact;
    }

    private static boolean checkArtifact(Artifact artifact, ReleaseDescriptor releaseDescriptor) {
        boolean bannedVersion;
        String versionlessKey = ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        String releaseDescriptorResolvedVersion = releaseDescriptor.getDependencyReleaseVersion(versionlessKey);
        boolean releaseDescriptorResolvedVersionIsSnapshot = releaseDescriptorResolvedVersion == null || releaseDescriptorResolvedVersion.contains("SNAPSHOT");
        boolean bl = bannedVersion = artifact.isSnapshot() && !artifact.getBaseVersion().equals(releaseDescriptor.getProjectOriginalVersion(versionlessKey)) && releaseDescriptorResolvedVersionIsSnapshot;
        if (bannedVersion && releaseDescriptor.isAllowTimestampedSnapshots()) {
            bannedVersion = artifact.getVersion().contains("SNAPSHOT");
        }
        return bannedVersion;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }

    private void printSnapshotDependencies(Set<Artifact> snapshotsSet, StringBuilder message) {
        ArrayList<Artifact> snapshotsList = new ArrayList<Artifact>(snapshotsSet);
        Collections.sort(snapshotsList);
        for (Artifact artifact : snapshotsList) {
            message.append("    ");
            message.append(artifact);
            message.append("\n");
        }
    }

    private void resolveSnapshots(Set<Artifact> projectDependencies, Set<Artifact> reportDependencies, Set<Artifact> extensionDependencies, Set<Artifact> pluginDependencies, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException {
        block28: {
            try {
                String autoResolveSnapshots = releaseDescriptor.getAutoResolveSnapshots();
                if (this.resolveSnapshot == null) {
                    this.prompter.get().showMessage(RESOLVE_SNAPSHOT_MESSAGE);
                    if (autoResolveSnapshots != null) {
                        this.resolveSnapshot = "yes";
                        this.prompter.get().showMessage("Do you want to resolve them now? " + this.resolveSnapshot);
                    } else {
                        this.resolveSnapshot = this.prompter.get().prompt(RESOLVE_SNAPSHOT_PROMPT, Arrays.asList("yes", "no"), "no");
                    }
                }
                if (!this.resolveSnapshot.toLowerCase(Locale.ENGLISH).startsWith("y")) break block28;
                if (this.resolveSnapshotType == null) {
                    this.prompter.get().showMessage(RESOLVE_SNAPSHOT_TYPE_MESSAGE);
                    int defaultAnswer = -1;
                    if (autoResolveSnapshots != null) {
                        if ("all".equalsIgnoreCase(autoResolveSnapshots)) {
                            defaultAnswer = 0;
                        } else if ("dependencies".equalsIgnoreCase(autoResolveSnapshots)) {
                            defaultAnswer = 1;
                        } else if ("plugins".equalsIgnoreCase(autoResolveSnapshots)) {
                            defaultAnswer = 2;
                        } else if ("reports".equalsIgnoreCase(autoResolveSnapshots)) {
                            defaultAnswer = 3;
                        } else if ("extensions".equalsIgnoreCase(autoResolveSnapshots)) {
                            defaultAnswer = 4;
                        } else {
                            try {
                                defaultAnswer = Integer.parseInt(autoResolveSnapshots);
                            }
                            catch (NumberFormatException e) {
                                throw new ReleaseExecutionException(e.getMessage(), e);
                            }
                        }
                    }
                    if (defaultAnswer >= 0 && defaultAnswer <= 4) {
                        this.prompter.get().showMessage("specify the selection number ( 0:All 1:Project Dependencies 2:Plugins 3:Reports 4:Extensions ): " + autoResolveSnapshots);
                        this.resolveSnapshotType = Integer.toString(defaultAnswer);
                    } else {
                        this.resolveSnapshotType = this.prompter.get().prompt(RESOLVE_SNAPSHOT_TYPE_PROMPT, Arrays.asList("0", "1", "2", "3"), "1");
                    }
                }
                switch (Integer.parseInt(this.resolveSnapshotType.toLowerCase(Locale.ENGLISH))) {
                    case 0: {
                        this.processSnapshot(projectDependencies, releaseDescriptor, autoResolveSnapshots);
                        this.processSnapshot(pluginDependencies, releaseDescriptor, autoResolveSnapshots);
                        this.processSnapshot(reportDependencies, releaseDescriptor, autoResolveSnapshots);
                        this.processSnapshot(extensionDependencies, releaseDescriptor, autoResolveSnapshots);
                        break;
                    }
                    case 1: {
                        this.processSnapshot(projectDependencies, releaseDescriptor, autoResolveSnapshots);
                        break;
                    }
                    case 2: {
                        this.processSnapshot(pluginDependencies, releaseDescriptor, autoResolveSnapshots);
                        break;
                    }
                    case 3: {
                        this.processSnapshot(reportDependencies, releaseDescriptor, autoResolveSnapshots);
                        break;
                    }
                    case 4: {
                        this.processSnapshot(extensionDependencies, releaseDescriptor, autoResolveSnapshots);
                        break;
                    }
                }
            }
            catch (VersionParseException | PrompterException e) {
                throw new ReleaseExecutionException(e.getMessage(), e);
            }
        }
    }

    private void processSnapshot(Set<Artifact> snapshotSet, ReleaseDescriptor releaseDescriptor, String autoResolveSnapshots) throws PrompterException, VersionParseException {
        Iterator<Artifact> iterator = snapshotSet.iterator();
        while (iterator.hasNext()) {
            String result;
            Artifact currentArtifact = iterator.next();
            String versionlessKey = ArtifactUtils.versionlessKey(currentArtifact);
            DefaultVersionInfo versionInfo = new DefaultVersionInfo(currentArtifact.getBaseVersion());
            releaseDescriptor.addDependencyOriginalVersion(versionlessKey, ((Object)versionInfo).toString());
            this.prompter.get().showMessage("Dependency '" + versionlessKey + "' is a snapshot (" + currentArtifact.getVersion() + ")\n");
            String message = "Which release version should it be set to?";
            if (null != autoResolveSnapshots) {
                result = versionInfo.getReleaseVersionString();
                this.prompter.get().showMessage(message + " " + result);
            } else {
                result = this.prompter.get().prompt(message, versionInfo.getReleaseVersionString());
            }
            releaseDescriptor.addDependencyReleaseVersion(versionlessKey, result);
            iterator.remove();
            DefaultVersionInfo nextVersionInfo = new DefaultVersionInfo(result);
            String nextVersion = nextVersionInfo.compareTo(versionInfo) > 0 ? ((Object)nextVersionInfo).toString() : ((Object)versionInfo).toString();
            message = "What version should the dependency be reset to for development?";
            if (null != autoResolveSnapshots) {
                result = nextVersion;
                this.prompter.get().showMessage(message + " " + result);
            } else {
                result = this.prompter.get().prompt(message, nextVersion);
            }
            releaseDescriptor.addDependencyDevelopmentVersion(versionlessKey, result);
        }
    }
}

