/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.transform.ModelETLFactory;
import org.apache.maven.shared.release.util.ReleaseUtil;

@Singleton
@Named(value="rewrite-poms-for-branch")
public class RewritePomsForBranchPhase
extends AbstractRewritePomsPhase {
    @Inject
    public RewritePomsForBranchPhase(ScmRepositoryConfigurator scmRepositoryConfigurator, Map<String, ModelETLFactory> modelETLFactories, Map<String, ScmTranslator> scmTranslators) {
        super(scmRepositoryConfigurator, modelETLFactories, scmTranslators);
    }

    @Override
    protected final String getPomSuffix() {
        return "branch";
    }

    @Override
    protected void transformScm(MavenProject project, Model modelTarget, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result) throws ReleaseExecutionException {
        if (project.getScm() != null) {
            String parentId;
            Scm scmRoot = modelTarget.getScm();
            if (scmRoot != null) {
                try {
                    this.translateScm(project, releaseDescriptor, scmRoot, scmRepository, result);
                }
                catch (IOException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            MavenProject parent = project.getParent();
            if (parent != null && !releaseDescriptor.hasOriginalScmInfo(parentId = ArtifactUtils.versionlessKey(parent.getGroupId(), parent.getArtifactId()))) {
                scmRoot = new Scm();
                scmRoot.setTag(null);
                try {
                    if (this.translateScm(project, releaseDescriptor, scmRoot, scmRepository, result)) {
                        modelTarget.setScm(scmRoot);
                    }
                }
                catch (IOException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseDescriptor releaseDescriptor, Scm scmTarget, ScmRepository scmRepository, ReleaseResult relResult) throws IOException {
        ScmTranslator translator = this.getScmTranslators().get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            String value2;
            String trunkUrl;
            String subDirectoryBranch;
            String rootUrl;
            Scm scm = project.getOriginalModel().getScm();
            if (scm == null) {
                scm = project.getScm();
            }
            String branchName = releaseDescriptor.getScmReleaseLabel();
            String branchBase = releaseDescriptor.getScmBranchBase();
            if (branchBase != null) {
                branchBase = "scm:svn:" + branchBase;
            }
            Path projectBasedir = project.getBasedir().toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
            Path workingDirectory = Paths.get(releaseDescriptor.getWorkingDirectory(), new String[0]);
            int count = ReleaseUtil.getBaseWorkingDirectoryParentCount(workingDirectory, projectBasedir);
            if (scm.getConnection() != null) {
                String scmConnectionBranch;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getConnection());
                subDirectoryBranch = scm.getConnection().substring(rootUrl.length());
                if (!subDirectoryBranch.startsWith("/")) {
                    subDirectoryBranch = "/" + subDirectoryBranch;
                }
                if ((scmConnectionBranch = branchBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    scmConnectionBranch = RewritePomsForBranchPhase.translateUrlPath(trunkUrl, branchBase, scm.getConnection());
                }
                if (!(value2 = translator.translateBranchUrl(scm.getConnection(), branchName + subDirectoryBranch, scmConnectionBranch)).equals(scm.getConnection())) {
                    scmTarget.setConnection(value2);
                    result = true;
                }
            }
            if (scm.getDeveloperConnection() != null) {
                String value3;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getDeveloperConnection());
                subDirectoryBranch = scm.getDeveloperConnection().substring(rootUrl.length());
                if (!subDirectoryBranch.startsWith("/")) {
                    subDirectoryBranch = "/" + subDirectoryBranch;
                }
                if (!(value3 = translator.translateBranchUrl(scm.getDeveloperConnection(), branchName + subDirectoryBranch, branchBase)).equals(scm.getDeveloperConnection())) {
                    scmTarget.setDeveloperConnection(value3);
                    result = true;
                }
            }
            if (scm.getUrl() != null) {
                String tagScmUrl;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getUrl());
                subDirectoryBranch = scm.getUrl().substring(rootUrl.length());
                if (!subDirectoryBranch.startsWith("/")) {
                    subDirectoryBranch = "/" + subDirectoryBranch;
                }
                if ((tagScmUrl = branchBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    tagScmUrl = RewritePomsForBranchPhase.translateUrlPath(trunkUrl, branchBase, scm.getUrl());
                }
                if (!(value2 = translator.translateBranchUrl(scm.getUrl(), branchName + subDirectoryBranch, tagScmUrl)).equals(scm.getUrl())) {
                    scmTarget.setUrl(value2);
                    result = true;
                }
            }
            if (branchName != null && (value = translator.resolveTag(branchName)) != null && !value.equals(scm.getTag())) {
                scmTarget.setTag(value);
                result = true;
            }
        } else {
            String message = "No SCM translator found - skipping rewrite";
            relResult.appendDebug(message);
            this.getLogger().debug(message);
        }
        return result;
    }

    @Override
    protected String getOriginalVersion(ReleaseDescriptor releaseDescriptor, String projectKey, boolean simulate) {
        return releaseDescriptor.getProjectOriginalVersion(projectKey);
    }

    @Override
    protected String getNextVersion(ReleaseDescriptor releaseDescriptor, String key) {
        return releaseDescriptor.getProjectReleaseVersion(key);
    }

    @Override
    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getDependencyReleaseVersion(artifactVersionlessKey);
    }
}

