/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.transform.ModelETLFactory;
import org.apache.maven.shared.release.util.ReleaseUtil;

@Singleton
@Named(value="rewrite-poms-for-release")
public class RewritePomsForReleasePhase
extends AbstractRewritePomsPhase {
    @Inject
    public RewritePomsForReleasePhase(ScmRepositoryConfigurator scmRepositoryConfigurator, Map<String, ModelETLFactory> modelETLFactories, Map<String, ScmTranslator> scmTranslators) {
        super(scmRepositoryConfigurator, modelETLFactories, scmTranslators);
    }

    @Override
    protected final String getPomSuffix() {
        return "tag";
    }

    @Override
    protected void transformScm(MavenProject project, Model modelTarget, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result) throws ReleaseExecutionException {
        if (project.getScm() != null) {
            String parentId;
            Scm scmRoot = modelTarget.getScm();
            if (scmRoot != null) {
                try {
                    this.translateScm(project, releaseDescriptor, scmRoot, scmRepository, result);
                }
                catch (IOException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
            MavenProject parent = project.getParent();
            if (parent != null && !releaseDescriptor.hasOriginalScmInfo(parentId = ArtifactUtils.versionlessKey(parent.getGroupId(), parent.getArtifactId()))) {
                Scm scmTarget = new Scm();
                scmTarget.setTag(null);
                try {
                    if (this.translateScm(project, releaseDescriptor, scmTarget, scmRepository, result)) {
                        modelTarget.setScm(scmTarget);
                    }
                }
                catch (IOException e) {
                    throw new ReleaseExecutionException(e.getMessage(), e);
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseDescriptor releaseDescriptor, Scm scmTarget, ScmRepository scmRepository, ReleaseResult relResult) throws IOException {
        ScmTranslator translator = this.getScmTranslators().get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            String value2;
            String trunkUrl;
            String subDirectoryTag;
            String rootUrl;
            Scm scm = project.getOriginalModel().getScm();
            if (scm == null) {
                scm = project.getScm();
            }
            String tag = releaseDescriptor.getScmReleaseLabel();
            String tagBase = releaseDescriptor.getScmTagBase();
            if (tagBase != null) {
                tagBase = "scm:svn:" + tagBase;
            }
            Path projectBasedir = project.getBasedir().toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
            Path workingDirectory = Paths.get(releaseDescriptor.getWorkingDirectory(), new String[0]);
            int count = ReleaseUtil.getBaseWorkingDirectoryParentCount(workingDirectory, projectBasedir);
            if (scm.getConnection() != null) {
                String scmConnectionTag;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getConnection());
                subDirectoryTag = scm.getConnection().substring(rootUrl.length());
                if (!subDirectoryTag.startsWith("/")) {
                    subDirectoryTag = "/" + subDirectoryTag;
                }
                if ((scmConnectionTag = tagBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    scmConnectionTag = RewritePomsForReleasePhase.translateUrlPath(trunkUrl, tagBase, scm.getConnection());
                }
                if (!(value2 = translator.translateTagUrl(scm.getConnection(), tag + subDirectoryTag, scmConnectionTag)).equals(scm.getConnection())) {
                    scmTarget.setConnection(value2);
                    result = true;
                }
            }
            if (scm.getDeveloperConnection() != null) {
                String value3;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getDeveloperConnection());
                subDirectoryTag = scm.getDeveloperConnection().substring(rootUrl.length());
                if (!subDirectoryTag.startsWith("/")) {
                    subDirectoryTag = "/" + subDirectoryTag;
                }
                if (!(value3 = translator.translateTagUrl(scm.getDeveloperConnection(), tag + subDirectoryTag, tagBase)).equals(scm.getDeveloperConnection())) {
                    scmTarget.setDeveloperConnection(value3);
                    result = true;
                }
            }
            if (scm.getUrl() != null) {
                String tagScmUrl;
                rootUrl = ReleaseUtil.realignScmUrl(count, scm.getUrl());
                subDirectoryTag = scm.getUrl().substring(rootUrl.length());
                if (!subDirectoryTag.startsWith("/")) {
                    subDirectoryTag = "/" + subDirectoryTag;
                }
                if ((tagScmUrl = tagBase) != null) {
                    trunkUrl = scm.getDeveloperConnection();
                    if (trunkUrl == null) {
                        trunkUrl = scm.getConnection();
                    }
                    tagScmUrl = RewritePomsForReleasePhase.translateUrlPath(trunkUrl, tagBase, scm.getUrl());
                }
                if (!(value2 = translator.translateTagUrl(scm.getUrl(), tag + subDirectoryTag, tagScmUrl)).equals(scm.getUrl())) {
                    scmTarget.setUrl(value2);
                    result = true;
                }
            }
            if (tag != null && (value = translator.resolveTag(tag)) != null && !value.equals(scm.getTag())) {
                scmTarget.setTag(value);
                result = true;
            }
        } else {
            String message = "No SCM translator found - skipping rewrite";
            relResult.appendDebug(message);
            this.getLogger().debug(message);
        }
        return result;
    }

    @Override
    protected String getOriginalVersion(ReleaseDescriptor releaseDescriptor, String projectKey, boolean simulate) {
        return releaseDescriptor.getProjectOriginalVersion(projectKey);
    }

    @Override
    protected String getNextVersion(ReleaseDescriptor releaseDescriptor, String key) {
        return releaseDescriptor.getProjectReleaseVersion(key);
    }

    @Override
    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getDependencyReleaseVersion(artifactVersionlessKey);
    }
}

