/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.phase.AbstractRunGoalsPhase;
import org.apache.maven.shared.release.util.PomFinder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named(value="run-perform-goals")
public class RunPerformGoalsPhase
extends AbstractRunGoalsPhase {
    @Inject
    public RunPerformGoalsPhase(Map<String, MavenExecutor> mavenExecutors) {
        super(mavenExecutors);
    }

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        return this.runLogic(releaseDescriptor, releaseEnvironment, false);
    }

    private ReleaseResult runLogic(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, boolean simulate) throws ReleaseExecutionException {
        File matchingPom;
        String pomFileName;
        String additionalArguments = this.getAdditionalArguments(releaseDescriptor);
        if (releaseDescriptor.isUseReleaseProfile()) {
            additionalArguments = additionalArguments != null && !additionalArguments.isEmpty() ? additionalArguments + " -DperformRelease=true" : "-DperformRelease=true";
        }
        if ((pomFileName = releaseDescriptor.getPomFileName()) == null) {
            pomFileName = "pom.xml";
        }
        additionalArguments = additionalArguments != null && !additionalArguments.isEmpty() ? additionalArguments + " -f " + pomFileName : "-f " + pomFileName;
        if (simulate) {
            ReleaseResult result = new ReleaseResult();
            this.logInfo(result, "Simulating perform goals '" + MessageUtils.buffer().strong(this.getGoals(releaseDescriptor)) + "' - since this is simulation mode these goals are skipped.");
            this.logInfo(result, "    with additional arguments: " + additionalArguments);
            return result;
        }
        String workDir = releaseDescriptor.getWorkingDirectory();
        if (workDir == null) {
            workDir = System.getProperty("user.dir");
        }
        File pomFile = new File(workDir, pomFileName);
        PomFinder pomFinder = new PomFinder(this.getLogger());
        boolean foundPom = false;
        if (StringUtils.isEmpty(releaseDescriptor.getScmRelativePathProjectDirectory())) {
            foundPom = pomFinder.parsePom(pomFile);
        }
        File workDirectory = new File(releaseDescriptor.getCheckoutDirectory());
        if (foundPom && (matchingPom = pomFinder.findMatchingPom(workDirectory)) != null) {
            this.getLogger().info("Invoking perform goals in directory " + matchingPom.getParent());
            workDirectory = matchingPom.getParentFile();
        }
        return this.execute(releaseDescriptor, releaseEnvironment, workDirectory, additionalArguments, false);
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        return this.runLogic(releaseDescriptor, releaseEnvironment, true);
    }

    @Override
    protected String getGoals(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getPerformGoals();
    }
}

