/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.transform.jdom2;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.transform.ModelETL;
import org.apache.maven.shared.release.transform.jdom2.JDomModel;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.ElementFilter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;

public class JDomModelETL
implements ModelETL {
    private ReleaseDescriptor releaseDescriptor;
    private MavenProject project;
    private Document document;
    private String intro = null;
    private String outtro = null;
    private String ls = ReleaseUtil.LS;

    public void setLs(String ls) {
        this.ls = ls;
    }

    public void setReleaseDescriptor(ReleaseDescriptor releaseDescriptor) {
        this.releaseDescriptor = releaseDescriptor;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public void extract(File pomFile) throws ReleaseExecutionException {
        try {
            String content = ReleaseUtil.readXmlFile(pomFile, this.ls);
            content = content.replaceAll("<([^!][^>]*?)\\s{2,}([^>]*?)>", "<$1 $2>");
            content = content.replaceAll("(\\s{2,})/>", "$1 />");
            SAXBuilder builder = new SAXBuilder();
            this.document = builder.build(new StringReader(content));
            this.normaliseLineEndings(this.document);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            format.setLineSeparator(this.ls);
            XMLOutputter out = new XMLOutputter(format);
            out.output(this.document.getRootElement(), (Writer)w);
            int index = content.indexOf(w.toString());
            if (index >= 0) {
                this.intro = content.substring(0, index);
                this.outtro = content.substring(index + w.toString().length());
            } else {
                String SPACE = "\\s++";
                String XML2 = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
                String INTSUB = "\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]";
                String DOCTYPE = "<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>";
                String PI = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
                String COMMENT = "<!--(?:[^-]|(?:-[^-]))*+-->";
                String INTRO = "(?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
                String OUTRO = "(?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
                String POM = "(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)";
                Matcher matcher = Pattern.compile("(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)").matcher(content);
                if (matcher.matches()) {
                    this.intro = matcher.group(1);
                    this.outtro = matcher.group(matcher.groupCount());
                }
            }
        }
        catch (IOException | JDOMException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
    }

    @Override
    public void transform() {
    }

    @Override
    public void load(File targetFile) throws ReleaseExecutionException {
        this.writePom(targetFile, this.document, this.releaseDescriptor, this.project.getModelVersion(), this.intro, this.outtro);
    }

    @Override
    public Model getModel() {
        return new JDomModel(this.document);
    }

    private void normaliseLineEndings(Document document) {
        Content c;
        IteratorIterable<Content> i = document.getDescendants(new ContentFilter(8));
        while (i.hasNext()) {
            c = (Comment)i.next();
            ((Comment)c).setText(ReleaseUtil.normalizeLineEndings(((Comment)c).getText(), this.ls));
        }
        i = document.getDescendants(new ContentFilter(2));
        while (i.hasNext()) {
            c = (CDATA)i.next();
            ((CDATA)c).setText(ReleaseUtil.normalizeLineEndings(((Text)c).getText(), this.ls));
        }
    }

    private void writePom(File pomFile, Document document, ReleaseDescriptor releaseDescriptor, String modelVersion, String intro, String outtro) throws ReleaseExecutionException {
        Element rootElement = document.getRootElement();
        if (releaseDescriptor.isAddSchema()) {
            Namespace pomNamespace = Namespace.getNamespace("", "http://maven.apache.org/POM/" + modelVersion);
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/" + modelVersion + " https://maven.apache.org/xsd/maven-" + modelVersion + ".xsd", xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace(""));
            IteratorIterable<Element> i = rootElement.getDescendants(elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
        }
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter(pomFile);){
            if (intro != null) {
                writer.write(intro);
            }
            Format format = Format.getRawFormat();
            format.setLineSeparator(this.ls);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)writer);
            if (outtro != null) {
                writer.write(outtro);
            }
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error writing POM: " + e.getMessage(), e);
        }
    }
}

