/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;

public class PomFinder {
    private final Logger log;
    private PomInfo foundPomInfo;

    public PomFinder(Logger log) {
        this.log = Objects.requireNonNull(log);
    }

    public boolean parsePom(File originPom) {
        if (!originPom.exists()) {
            return false;
        }
        try {
            this.foundPomInfo = this.readPomInfo(originPom);
        }
        catch (Exception e) {
            this.log.warn("Error while parsing pom file", e);
            return false;
        }
        return this.foundPomInfo != null;
    }

    public File findMatchingPom(File startDirectory) {
        String[] childFiles;
        if (!startDirectory.exists()) {
            return null;
        }
        if (!startDirectory.isDirectory()) {
            this.log.error("PomFinder must be started with a directory! Got " + startDirectory.getAbsolutePath());
            return null;
        }
        if (this.foundPomInfo == null) {
            this.log.error("Please run parsePom first!");
            return null;
        }
        File matchingPom = new File(startDirectory, this.foundPomInfo.getFileName());
        if (matchingPom.exists()) {
            PomInfo pi = null;
            try {
                pi = this.readPomInfo(matchingPom);
            }
            catch (Exception e) {
                this.log.warn("Error while parsing pom file", e);
            }
            if (pi == null || !pi.equals(this.foundPomInfo)) {
                matchingPom = null;
            }
        } else {
            matchingPom = null;
        }
        if (matchingPom == null && (childFiles = startDirectory.list()) != null) {
            for (String childFile : childFiles) {
                File subDir = new File(startDirectory, childFile);
                if (subDir.isDirectory() && !subDir.isHidden()) {
                    matchingPom = this.findMatchingPom(subDir);
                }
                if (matchingPom != null) break;
            }
        }
        return matchingPom;
    }

    private PomInfo readPomInfo(File pomFile) throws IOException, XmlPullParserException {
        Model model;
        if (!pomFile.exists() || !pomFile.isFile()) {
            return null;
        }
        PomInfo pomInfo = null;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (XmlStreamReader xmlReader = ReaderFactory.newXmlReader(pomFile);){
            model = reader.read(xmlReader);
        }
        if (model != null) {
            pomInfo = new PomInfo();
            pomInfo.setArtifactId(model.getArtifactId());
            pomInfo.setGroupId(model.getGroupId());
            Parent parent = model.getParent();
            if (parent != null) {
                pomInfo.setParentArtifactId(parent.getArtifactId());
                pomInfo.setParentGroupId(parent.getGroupId());
            }
            pomInfo.setFileName(pomFile.getName());
        }
        return pomInfo;
    }

    private static class PomInfo {
        private String fileName;
        private String artifactId;
        private String groupId;
        private String parentArtifactId;
        private String parentGroupId;

        private PomInfo() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setParentArtifactId(String parentArtifactId) {
            this.parentArtifactId = parentArtifactId;
        }

        public void setParentGroupId(String parentGroupId) {
            this.parentGroupId = parentGroupId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PomInfo pomInfo = (PomInfo)o;
            if (this.artifactId != null ? !this.artifactId.equals(pomInfo.artifactId) : pomInfo.artifactId != null) {
                return false;
            }
            if (this.groupId != null ? !this.groupId.equals(pomInfo.groupId) : pomInfo.groupId != null) {
                return false;
            }
            if (this.parentArtifactId != null ? !this.parentArtifactId.equals(pomInfo.parentArtifactId) : pomInfo.parentArtifactId != null) {
                return false;
            }
            return !(this.parentGroupId != null ? !this.parentGroupId.equals(pomInfo.parentGroupId) : pomInfo.parentGroupId != null);
        }

        public int hashCode() {
            int result = this.artifactId != null ? this.artifactId.hashCode() : 0;
            result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
            result = 31 * result + (this.parentArtifactId != null ? this.parentArtifactId.hashCode() : 0);
            result = 31 * result + (this.parentGroupId != null ? this.parentGroupId.hashCode() : 0);
            return result;
        }
    }
}

