/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class ReleaseUtil {
    public static final String RELEASE_POMv4 = "release-pom.xml";
    public static final String POMv4 = "pom.xml";
    public static final String LS = System.getProperty("line.separator");

    private ReleaseUtil() {
    }

    public static MavenProject getRootProject(List<MavenProject> reactorProjects) {
        MavenProject project = reactorProjects.get(0);
        for (MavenProject currentProject : reactorProjects) {
            if (!currentProject.isExecutionRoot()) continue;
            project = currentProject;
            break;
        }
        return project;
    }

    public static File getStandardPom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        File releasePom = ReleaseUtil.getReleasePom(project);
        if (pom.equals(releasePom)) {
            pom = new File(pom.getParent(), POMv4);
        }
        return pom;
    }

    public static File getReleasePom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        return new File(pom.getParent(), RELEASE_POMv4);
    }

    public static String readXmlFile(File file) throws IOException {
        return ReleaseUtil.readXmlFile(file, LS);
    }

    public static String readXmlFile(File file, String ls) throws IOException {
        try (XmlStreamReader reader = ReaderFactory.newXmlReader(file);){
            String string = ReleaseUtil.normalizeLineEndings(IOUtil.toString(reader), ls);
            return string;
        }
    }

    public static String normalizeLineEndings(String text, String separator) {
        String norm = text;
        if (text != null) {
            norm = text.replaceAll("(\r\n)|(\n)|(\r)", separator);
        }
        return norm;
    }

    public static ReleaseDescriptor createBasedirAlignedReleaseDescriptor(ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        int parentLevels = Paths.get(releaseDescriptor.getPomFileName(), new String[0]).getNameCount() - 1;
        String url = releaseDescriptor.getScmSourceUrl();
        url = ReleaseUtil.realignScmUrl(parentLevels, url);
        ReleaseDescriptorBuilder builder = new ReleaseDescriptorBuilder();
        builder.setWorkingDirectory(releaseDescriptor.getWorkingDirectory());
        builder.setScmSourceUrl(url);
        return ReleaseUtils.buildReleaseDescriptor(builder);
    }

    public static int getBaseWorkingDirectoryParentCount(Path baseDirectory, Path workingDirectory) {
        return Math.max(0, workingDirectory.normalize().getNameCount() - baseDirectory.normalize().getNameCount());
    }

    public static String realignScmUrl(int parentLevels, String url) {
        if (url != null && !url.isEmpty()) {
            url = url.replaceAll("/\\./", "/").replaceAll("/\\.$", "").replaceAll("/[^/]+/\\.\\./", "/").replaceAll("/[^/]+/\\.\\.$", "");
            int index = url.length();
            String suffix = "";
            if (url.endsWith("/")) {
                --index;
                suffix = "/";
            }
            for (int i = 0; i < parentLevels && index > 0; ++i) {
                index = url.lastIndexOf(47, index - 1);
            }
            if (index > 0) {
                url = url.substring(0, index) + suffix;
            }
        }
        return url;
    }

    public static String interpolate(String value, Model model) throws ReleaseExecutionException {
        if (value != null && value.contains("${")) {
            StringSearchInterpolator interpolator = new StringSearchInterpolator();
            List<String> pomPrefixes = Arrays.asList("pom.", "project.");
            interpolator.addValueSource(new PrefixedObjectValueSource(pomPrefixes, model, false));
            interpolator.addValueSource(new MapBasedValueSource(model.getProperties()));
            interpolator.addValueSource(new ObjectBasedValueSource(model));
            try {
                value = interpolator.interpolate(value, new PrefixAwareRecursionInterceptor(pomPrefixes));
            }
            catch (InterpolationException e) {
                throw new ReleaseExecutionException("Failed to interpolate " + value + " for project " + model.getId(), e);
            }
        }
        return value;
    }
}

