/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.resolve.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.SonatypeAetherFilterTransformer;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven30ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven30DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.MavenDependencyResolver;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;

class Maven30DependencyResolver
implements MavenDependencyResolver {
    private static final Class<?>[] ARG_CLASSES = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
    private final RepositorySystem repositorySystem;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> aetherRepositories;

    Maven30DependencyResolver(RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager, RepositorySystemSession session, List<RemoteRepository> aetherRepositories) {
        this.repositorySystem = repositorySystem;
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.aetherRepositories = aetherRepositories;
    }

    private static Dependency toDependency(DependableCoordinate coordinate, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(coordinate.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(coordinate.getType());
        }
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), null, coordinate.getVersion(), null, stereotype);
        return new Dependency((Artifact)artifact, null);
    }

    private static Dependency toDependency(org.apache.maven.model.Dependency mavenDependency, ArtifactTypeRegistry typeRegistry) throws DependencyResolverException {
        Object[] args = new Object[]{mavenDependency, typeRegistry};
        return (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", ARG_CLASSES, args);
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(DependableCoordinate coordinate, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = this.createTypeRegistry();
        Dependency aetherRoot = Maven30DependencyResolver.toDependency(coordinate, typeRegistry);
        CollectRequest request = new CollectRequest(aetherRoot, this.aetherRepositories);
        return this.resolveDependencies(dependencyFilter, request);
    }

    private ArtifactTypeRegistry createTypeRegistry() throws DependencyResolverException {
        return (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, this.artifactHandlerManager);
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(Model model, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(model.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), extension, model.getVersion());
        Dependency aetherRoot = new Dependency((Artifact)aetherArtifact, null);
        CollectRequest request = new CollectRequest(aetherRoot, this.aetherRepositories);
        request.setDependencies(this.resolveDependencies(model.getDependencies()));
        DependencyManagement mavenDependencyManagement = model.getDependencyManagement();
        if (mavenDependencyManagement != null) {
            request.setManagedDependencies(this.resolveDependencies(mavenDependencyManagement.getDependencies()));
        }
        return this.resolveDependencies(dependencyFilter, request);
    }

    private List<Dependency> resolveDependencies(Collection<org.apache.maven.model.Dependency> mavenDependencies) throws DependencyResolverException {
        if (mavenDependencies == null) {
            return Collections.emptyList();
        }
        ArtifactTypeRegistry typeRegistry = this.createTypeRegistry();
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>(mavenDependencies.size());
        for (org.apache.maven.model.Dependency mavenDependency : mavenDependencies) {
            aetherDependencies.add(Maven30DependencyResolver.toDependency(mavenDependency, typeRegistry));
        }
        return aetherDependencies;
    }

    @Override
    public Iterable<ArtifactResult> resolveDependencies(Collection<org.apache.maven.model.Dependency> mavenDependencies, Collection<org.apache.maven.model.Dependency> managedMavenDependencies, TransformableFilter filter) throws DependencyResolverException {
        List<Dependency> aetherDependencies = this.resolveDependencies(mavenDependencies);
        List<Dependency> aetherManagedDependencies = this.resolveDependencies(managedMavenDependencies);
        CollectRequest request = new CollectRequest(aetherDependencies, aetherManagedDependencies, this.aetherRepositories);
        return this.resolveDependencies(filter, request);
    }

    private Iterable<ArtifactResult> resolveDependencies(TransformableFilter dependencyFilter, CollectRequest request) throws DependencyResolverException {
        try {
            DependencyFilter depFilter = null;
            if (dependencyFilter != null) {
                depFilter = (DependencyFilter)dependencyFilter.transform(new SonatypeAetherFilterTransformer());
            }
            final List dependencyResults = this.repositorySystem.resolveDependencies(this.session, request, depFilter);
            return new Iterable<ArtifactResult>(){

                @Override
                public Iterator<ArtifactResult> iterator() {
                    ArrayList<Maven30ArtifactResult> artResults = new ArrayList<Maven30ArtifactResult>(dependencyResults.size());
                    for (org.sonatype.aether.resolution.ArtifactResult artifactResult : dependencyResults) {
                        artResults.add(new Maven30ArtifactResult(artifactResult));
                    }
                    return artResults.iterator();
                }
            };
        }
        catch (ArtifactResolutionException e) {
            throw new Maven30DependencyResolverException(e);
        }
        catch (DependencyCollectionException e) {
            throw new Maven30DependencyResolverException(e);
        }
    }
}

