/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Arg;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.shell.BourneShell;
import org.apache.maven.shared.utils.cli.shell.CmdShell;
import org.apache.maven.shared.utils.cli.shell.Shell;

public class Commandline
implements Cloneable {
    private final List<Arg> arguments = new Vector<Arg>();
    private final Map<String, String> envVars = Collections.synchronizedMap(new LinkedHashMap());
    private Shell shell;
    private boolean shellEnvironmentInherited = true;

    public Commandline(Shell shell) {
        this.shell = shell;
    }

    public Commandline(String toProcess) throws CommandLineException {
        this.setDefaultShell();
        String[] tmp = CommandLineUtils.translateCommandline(toProcess);
        if (tmp.length > 0) {
            this.setExecutable(tmp[0]);
            for (int i = 1; i < tmp.length; ++i) {
                this.createArg().setValue(tmp[i]);
            }
        }
    }

    public Commandline() {
        this.setDefaultShell();
    }

    private void setDefaultShell() {
        if (Os.isFamily("windows")) {
            this.setShell(new CmdShell());
        } else {
            this.setShell(new BourneShell());
        }
    }

    public Arg createArg() {
        return this.createArg(false);
    }

    public Arg createArg(boolean insertAtStart) {
        Argument argument = new Argument();
        if (insertAtStart) {
            this.arguments.add(0, argument);
        } else {
            this.arguments.add(argument);
        }
        return argument;
    }

    public void setExecutable(String executable) {
        this.shell.setExecutable(executable);
    }

    public String getExecutable() {
        return this.shell.getExecutable();
    }

    public void addArguments(String ... line) {
        for (String aLine : line) {
            this.createArg().setValue(aLine);
        }
    }

    public void addEnvironment(String name, String value) {
        this.envVars.put(name, value);
    }

    @Deprecated
    public void addSystemEnvironment() {
    }

    private void copySystemEnvironment() {
        Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
        for (Object o : systemEnvVars.keySet()) {
            String key = (String)o;
            if (this.envVars.containsKey(key)) continue;
            this.addEnvironment(key, systemEnvVars.getProperty(key));
        }
    }

    public String[] getEnvironmentVariables() {
        if (this.isShellEnvironmentInherited()) {
            this.copySystemEnvironment();
        }
        ArrayList<String> environmentVars = new ArrayList<String>();
        for (String name : this.envVars.keySet()) {
            String value = this.envVars.get(name);
            if (value == null) continue;
            environmentVars.add(name + "=" + value);
        }
        return environmentVars.toArray(new String[0]);
    }

    public String[] getCommandline() {
        String[] args = this.getArguments();
        String executable = this.getExecutable();
        if (executable == null) {
            return args;
        }
        String[] result = new String[args.length + 1];
        result[0] = executable;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    private String[] getShellCommandline() {
        return this.getShellCommandline(false);
    }

    private String[] getShellCommandline(boolean mask) {
        List<String> shellCommandLine = this.getShell().getShellCommandLine(this.getArguments(mask));
        return shellCommandLine.toArray(new String[shellCommandLine.size()]);
    }

    public String[] getArguments() {
        return this.getArguments(false);
    }

    public String[] getArguments(boolean mask) {
        ArrayList result = new ArrayList(this.arguments.size() * 2);
        for (Arg argument : this.arguments) {
            Argument arg = (Argument)argument;
            Object[] s2 = arg.getParts();
            if (s2 == null) continue;
            if (mask && arg.isMask() && s2.length > 0) {
                Object[] copy = new String[s2.length];
                Arrays.fill(copy, "*****");
                s2 = copy;
            }
            Collections.addAll(result, s2);
        }
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        return StringUtils.join(this.getShellCommandline(true), " ");
    }

    public Object clone() {
        throw new RuntimeException("Do we ever clone a commandline?");
    }

    public void setWorkingDirectory(String path) {
        this.shell.setWorkingDirectory(path);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.shell.setWorkingDirectory(workingDirectory);
    }

    public File getWorkingDirectory() {
        return this.shell.getWorkingDirectory();
    }

    public void clearArgs() {
        this.arguments.clear();
    }

    public boolean isShellEnvironmentInherited() {
        return this.shellEnvironmentInherited;
    }

    public void setShellEnvironmentInherited(boolean shellEnvironmentInherited) {
        this.shellEnvironmentInherited = shellEnvironmentInherited;
    }

    public Process execute() throws CommandLineException {
        Process process;
        String[] environment2 = this.getEnvironmentVariables();
        File workingDir = this.shell.getWorkingDirectory();
        try {
            if (workingDir == null) {
                process = Runtime.getRuntime().exec(this.getShellCommandline(), environment2);
            } else {
                if (!workingDir.exists()) {
                    throw new CommandLineException("Working directory \"" + workingDir.getPath() + "\" does not exist!");
                }
                if (!workingDir.isDirectory()) {
                    throw new CommandLineException("Path \"" + workingDir.getPath() + "\" does not specify a directory.");
                }
                process = Runtime.getRuntime().exec(this.getShellCommandline(), environment2, workingDir);
            }
        }
        catch (IOException ex) {
            throw new CommandLineException("Error while executing process.", ex);
        }
        return process;
    }

    void setShell(Shell shell) {
        this.shell = shell;
    }

    public Shell getShell() {
        return this.shell;
    }

    public static class Argument
    implements Arg {
        private String[] parts;
        private boolean mask;

        @Override
        public void setValue(String value) {
            if (value != null) {
                this.parts = new String[]{value};
            }
        }

        @Override
        public void setLine(String line) throws CommandLineException {
            if (line == null) {
                return;
            }
            this.parts = CommandLineUtils.translateCommandline(line);
        }

        @Override
        public void setFile(File value) {
            this.parts = new String[]{value.getAbsolutePath()};
        }

        @Override
        public void setMask(boolean mask) {
            this.mask = mask;
        }

        private String[] getParts() {
            return this.parts;
        }

        public boolean isMask() {
            return this.mask;
        }
    }
}

