/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private OutputStream out;
    private SshAgent agent;
    private AgentClient client;

    public ChannelAgentForwarding(CloseableExecutorService executor) {
        super("", Collections.emptyList(), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this, this);
        String changeEvent = "auth-agent";
        try {
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            Session session = this.getSession();
            FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            SshAgentFactory factory = Objects.requireNonNull(manager.getAgentFactory(), "No agent factory");
            this.agent = factory.createClient(session, manager);
            this.client = new AgentClient();
            this.signalChannelOpenSuccess();
            f.setOpened();
        }
        catch (Throwable t2) {
            Throwable e = ExceptionUtils.peelException(t2);
            changeEvent = e.getClass().getSimpleName();
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
        return f;
    }

    @Override
    public void handleEof() throws IOException {
        try {
            if (this.agent != null && this.agent.isOpen()) {
                this.agent.close();
            }
        }
        finally {
            super.handleEof();
        }
    }

    private void closeImmediately0() {
        try {
            if (this.agent != null && this.agent.isOpen()) {
                try {
                    this.agent.close();
                }
                catch (IOException e) {
                    this.log.error("closeImmediately0({}) Failed ({}) to close open local agent: {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
            }
        }
        finally {
            super.close(true);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        this.client.messageReceived(new ByteArrayBuffer(data, off, (int)len));
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    protected class AgentClient
    extends AbstractAgentClient {
        public AgentClient() {
            super(ChannelAgentForwarding.this.agent);
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            ChannelAgentForwarding.this.out.write(buf.array(), buf.rpos(), buf.available());
            ChannelAgentForwarding.this.out.flush();
        }
    }
}

