/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.helpers.CurrentService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ClientSessionImpl
extends AbstractClientSession {
    private volatile AuthFuture authFuture;
    private final AtomicReference<Throwable> beforeAuthErrorHolder = new AtomicReference();
    private final AtomicReference<Throwable> authErrorHolder = new AtomicReference();
    private final AtomicBoolean initialServiceRequestSent = new AtomicBoolean();
    private Map<Object, Object> metadataMap = new HashMap<Object, Object>();

    public ClientSessionImpl(ClientFactoryManager client, IoSession ioSession) throws Exception {
        super(client, ioSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client session created: {}", (Object)ioSession);
        }
        this.getCurrentServices().initialize(client.getServiceFactories());
        this.signalSessionCreated(ioSession);
        this.initializeProxyConnector();
        if (this.sendImmediateClientIdentification) {
            this.sendClientIdentification();
            if (this.sendImmediateKexInit) {
                this.initializeKeyExchangePhase();
            }
        }
    }

    @Override
    protected CurrentService initializeCurrentService() {
        return new Services(this);
    }

    private Services getCurrentServices() {
        return (Services)this.currentService;
    }

    @Override
    protected List<Service> getServices() {
        Services services = this.getCurrentServices();
        Service nextService = services.getNext();
        if (nextService != null) {
            return Arrays.asList(services.getService(), nextService);
        }
        return super.getServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture auth() throws IOException {
        Throwable earlyError;
        AuthFuture future;
        if (this.getUsername() == null) {
            throw new IllegalStateException("No username specified when the session was created");
        }
        ClientUserAuthService authService = this.getUserAuthService();
        String serviceName = this.nextServiceName();
        AtomicReference<Throwable> atomicReference = this.authErrorHolder;
        synchronized (atomicReference) {
            future = ValidateUtils.checkNotNull(authService.auth(serviceName), "No auth future generated by service=%s", (Object)serviceName);
            Throwable beforeAuthError = this.beforeAuthErrorHolder.get();
            earlyError = this.authFuture != null ? this.authErrorHolder.getAndSet(beforeAuthError) : beforeAuthError;
            this.authFuture = future;
        }
        if (earlyError != null) {
            future.setException(earlyError);
            if (this.log.isDebugEnabled()) {
                this.log.debug("auth({}) early exception type={}: {}", this, earlyError.getClass().getSimpleName(), earlyError.getMessage());
            }
        }
        return future;
    }

    @Override
    public void exceptionCaught(Throwable t2) {
        this.signalAuthFailure(t2);
        super.exceptionCaught(t2);
    }

    @Override
    protected void preClose() {
        this.signalAuthFailure(new SshException("Session is being closed"));
        super.preClose();
    }

    @Override
    protected void handleDisconnect(int code, String msg, String lang, Buffer buffer) throws Exception {
        this.signalAuthFailure(new SshException(code, msg));
        super.handleDisconnect(code, msg, lang, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalAuthFailure(Throwable t2) {
        AuthFuture future = this.authFuture;
        boolean firstError = false;
        if (future == null) {
            AtomicReference<Throwable> atomicReference = this.authErrorHolder;
            synchronized (atomicReference) {
                firstError = this.authErrorHolder.compareAndSet(null, t2);
                future = this.authFuture;
                if (future == null) {
                    this.beforeAuthErrorHolder.compareAndSet(null, t2);
                }
            }
        }
        if (future != null) {
            future.setException(t2);
        }
        if (this.log.isDebugEnabled()) {
            boolean signalled = future != null && t2 == future.getException();
            this.log.debug("signalAuthFailure({}) type={}, signalled={}, first={}: {}", this, t2.getClass().getSimpleName(), signalled, firstError, t2.getMessage());
        }
    }

    protected String nextServiceName() {
        return this.getCurrentServices().getNextName();
    }

    public void switchToNextService() throws IOException {
        this.getCurrentServices().switchServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void signalSessionEvent(SessionListener.Event event) throws Exception {
        if (SessionListener.Event.KeyEstablished.equals((Object)event)) {
            this.sendInitialServiceRequest();
        }
        Object object = this.futureLock;
        synchronized (object) {
            this.futureLock.notifyAll();
        }
        super.signalSessionEvent(event);
    }

    protected void sendInitialServiceRequest() throws IOException {
        if (this.initialServiceRequestSent.getAndSet(true)) {
            return;
        }
        Services services = this.getCurrentServices();
        String serviceName = services.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendInitialServiceRequest({}) Send SSH_MSG_SERVICE_REQUEST for {}", (Object)this, (Object)serviceName);
        }
        Buffer request = this.createBuffer((byte)5, serviceName.length() + 8);
        request.putString(serviceName);
        this.writePacket(request);
        services.start();
    }

    @Override
    public Set<ClientSession.ClientSessionEvent> waitFor(Collection<ClientSession.ClientSessionEvent> mask, long timeout) {
        Objects.requireNonNull(mask, "No mask specified");
        boolean traceEnabled = this.log.isTraceEnabled();
        long startTime = System.currentTimeMillis();
        Object object = this.futureLock;
        synchronized (object) {
            long remWait = timeout;
            EnumSet<ClientSession.ClientSessionEvent> cond = EnumSet.noneOf(ClientSession.ClientSessionEvent.class);
            while (true) {
                block16: {
                    long now;
                    long usedTime;
                    this.updateCurrentSessionState(cond);
                    boolean nothingInCommon = Collections.disjoint(cond, mask);
                    if (!nothingInCommon) {
                        if (traceEnabled) {
                            this.log.trace("waitFor({}) call return mask={}, cond={}", this, mask, cond);
                        }
                        return cond;
                    }
                    if (timeout > 0L && ((usedTime = (now = System.currentTimeMillis()) - startTime) >= timeout || remWait <= 0L)) {
                        if (traceEnabled) {
                            this.log.trace("waitFor({}) call timeout {}/{} for mask={}: {}", this, usedTime, timeout, mask, cond);
                        }
                        cond.add(ClientSession.ClientSessionEvent.TIMEOUT);
                        return cond;
                    }
                    if (traceEnabled) {
                        this.log.trace("waitFor({}) Waiting {} millis for lock on mask={}, cond={}", this, timeout, mask, cond);
                    }
                    long nanoStart = System.nanoTime();
                    try {
                        if (timeout > 0L) {
                            this.futureLock.wait(remWait);
                        } else {
                            this.futureLock.wait();
                        }
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (traceEnabled) {
                            this.log.trace("waitFor({}) Lock notified after {} nanos", (Object)this, (Object)nanoDuration);
                        }
                        if (timeout > 0L) {
                            long waitDuration = TimeUnit.MILLISECONDS.convert(nanoDuration, TimeUnit.NANOSECONDS);
                            if (waitDuration <= 0L) {
                                waitDuration = 123L;
                            }
                            remWait -= waitDuration;
                        }
                    }
                    catch (InterruptedException e) {
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (!traceEnabled) break block16;
                        this.log.trace("waitFor({}) mask={} - ignoring interrupted exception after {} nanos", this, mask, nanoDuration);
                    }
                }
                cond.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ClientSession.ClientSessionEvent> getSessionState() {
        EnumSet<ClientSession.ClientSessionEvent> state = EnumSet.noneOf(ClientSession.ClientSessionEvent.class);
        Object object = this.futureLock;
        synchronized (object) {
            return this.updateCurrentSessionState(state);
        }
    }

    protected <C extends Collection<ClientSession.ClientSessionEvent>> C updateCurrentSessionState(C state) {
        AuthFuture future;
        if (this.closeFuture.isClosed()) {
            state.add((ClientSession.ClientSessionEvent)ClientSession.ClientSessionEvent.CLOSED);
        }
        if (this.isAuthenticated()) {
            state.add((ClientSession.ClientSessionEvent)ClientSession.ClientSessionEvent.AUTHED);
        }
        if (KexState.DONE.equals(this.kexState.get()) && ((future = this.authFuture) == null || future.isFailure())) {
            state.add((ClientSession.ClientSessionEvent)ClientSession.ClientSessionEvent.WAIT_AUTH);
        }
        return state;
    }

    @Override
    public Map<Object, Object> getMetadataMap() {
        return this.metadataMap;
    }

    private static class Services
    extends CurrentService {
        private String nextName;
        private Service next;

        Services(ClientSessionImpl session) {
            super(session);
        }

        synchronized void initialize(List<? extends ServiceFactory> factories) throws IOException {
            int numFactories = GenericUtils.size(factories);
            ValidateUtils.checkTrue(numFactories > 0 && numFactories <= 2, "One or two services must be configured: %d", numFactories);
            ServiceFactory currentFactory = factories.get(0);
            this.set(currentFactory.create(this.session), currentFactory.getName(), false);
            if (numFactories > 1) {
                ServiceFactory nextFactory = factories.get(1);
                this.nextName = nextFactory.getName();
                this.next = nextFactory.create(this.session);
            }
        }

        synchronized void switchServices() throws IOException {
            if (this.next == null) {
                throw new IllegalStateException("No service available");
            }
            try {
                this.set(this.next, this.nextName, true);
            }
            finally {
                this.next = null;
                this.nextName = null;
            }
        }

        synchronized String getNextName() {
            return this.nextName;
        }

        synchronized Service getNext() {
            return this.next;
        }
    }
}

