/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.AbstractIoServiceFactoryFactory;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIoServiceFactoryFactory
extends AbstractIoServiceFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoServiceFactoryFactory.class);
    private IoServiceFactoryFactory factory;

    protected DefaultIoServiceFactoryFactory() {
        this((Factory<CloseableExecutorService>)null);
    }

    protected DefaultIoServiceFactoryFactory(Factory<CloseableExecutorService> factory) {
        super(factory);
    }

    @Override
    public IoServiceFactory create(FactoryManager manager) {
        IoServiceFactoryFactory factoryInstance = this.getIoServiceProvider();
        return factoryInstance.create(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoServiceFactoryFactory getIoServiceProvider() {
        DefaultIoServiceFactoryFactory defaultIoServiceFactoryFactory = this;
        synchronized (defaultIoServiceFactoryFactory) {
            if (this.factory != null) {
                return this.factory;
            }
            this.factory = DefaultIoServiceFactoryFactory.newInstance(IoServiceFactoryFactory.class);
            if (this.factory == null) {
                this.factory = BuiltinIoServiceFactoryFactories.NIO2.create();
                this.log.info("No detected/configured IoServiceFactoryFactory; using {}", (Object)this.factory.getClass().getSimpleName());
            } else {
                this.log.info("Using {}", (Object)this.factory.getClass().getSimpleName());
            }
            Factory<CloseableExecutorService> executorServiceFactory = this.getExecutorServiceFactory();
            if (executorServiceFactory != null) {
                this.factory.setExecutorServiceFactory(executorServiceFactory);
            }
        }
        return this.factory;
    }

    public static <T extends IoServiceFactoryFactory> T newInstance(Class<T> clazz) {
        T t2;
        T t3;
        String propName = clazz.getName();
        String factory = System.getProperty(propName);
        if (!GenericUtils.isEmpty(factory)) {
            return DefaultIoServiceFactoryFactory.newInstance(clazz, factory);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        if (cl != null && (t3 = DefaultIoServiceFactoryFactory.tryLoad(propName, ServiceLoader.load(clazz, cl))) != null) {
            return t3;
        }
        ClassLoader clDefault = DefaultIoServiceFactoryFactory.class.getClassLoader();
        if (cl != clDefault && (t2 = DefaultIoServiceFactoryFactory.tryLoad(propName, ServiceLoader.load(clazz, clDefault))) != null) {
            return t2;
        }
        return null;
    }

    public static <T extends IoServiceFactoryFactory> T tryLoad(String propName, ServiceLoader<T> loader) {
        Iterator<T> it = loader.iterator();
        LinkedList<IoServiceFactoryFactory> services = new LinkedList<IoServiceFactoryFactory>();
        try {
            while (it.hasNext()) {
                try {
                    IoServiceFactoryFactory instance = (IoServiceFactoryFactory)it.next();
                    services.add(instance);
                }
                catch (Throwable t2) {
                    LOGGER.warn("Exception while instantiating factory from ServiceLoader", t2);
                }
            }
        }
        catch (Throwable t3) {
            LOGGER.warn("Exception while loading factory from ServiceLoader", t3);
        }
        int numDetected = services.size();
        if (numDetected <= 0) {
            return null;
        }
        if (numDetected != 1) {
            LOGGER.error("Multiple ({}) registered instances detected:", (Object)numDetected);
            for (IoServiceFactoryFactory s2 : services) {
                LOGGER.error("===> {}", (Object)s2.getClass().getName());
            }
            throw new IllegalStateException("Multiple (" + numDetected + ") registered " + IoServiceFactoryFactory.class.getSimpleName() + " instances detected. Please use -D" + propName + "=...factory class.. to select one or remove the extra providers from the classpath");
        }
        return (T)((IoServiceFactoryFactory)services.removeFirst());
    }

    public static <T extends IoServiceFactoryFactory> T newInstance(Class<? extends T> clazz, String factory) {
        ClassLoader clDefault;
        BuiltinIoServiceFactoryFactories builtin = BuiltinIoServiceFactoryFactories.fromFactoryName(factory);
        if (builtin != null) {
            IoServiceFactoryFactory builtinInstance = builtin.create();
            return (T)((IoServiceFactoryFactory)clazz.cast(builtinInstance));
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        if (cl != null) {
            try {
                Class<?> loaded = cl.loadClass(factory);
                return (T)((IoServiceFactoryFactory)ReflectionUtils.newInstance(loaded, clazz));
            }
            catch (Throwable t2) {
                LOGGER.trace("Exception while loading factory " + factory, t2);
            }
        }
        if (cl != (clDefault = DefaultIoServiceFactoryFactory.class.getClassLoader())) {
            try {
                Class<?> loaded = clDefault.loadClass(factory);
                return (T)((IoServiceFactoryFactory)ReflectionUtils.newInstance(loaded, clazz));
            }
            catch (Throwable t3) {
                LOGGER.trace("Exception while loading factory " + factory, t3);
            }
        }
        throw new IllegalStateException("Unable to create instance of class " + factory);
    }

    public static DefaultIoServiceFactoryFactory getDefaultIoServiceFactoryFactoryInstance() {
        return LazyDefaultIoServiceFactoryFactoryHolder.INSTANCE;
    }

    private static final class LazyDefaultIoServiceFactoryFactoryHolder {
        private static final DefaultIoServiceFactoryFactory INSTANCE = new DefaultIoServiceFactoryFactory();

        private LazyDefaultIoServiceFactoryFactoryHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

