/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.List;
import java.util.Map;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.SshdEventListener;

public interface SessionListener
extends SshdEventListener {
    default public void sessionEstablished(Session session) {
    }

    default public void sessionCreated(Session session) {
    }

    default public void sessionPeerIdentificationSend(Session session, String version, List<String> extraLines) {
    }

    default public void sessionPeerIdentificationLine(Session session, String line, List<String> extraLines) {
    }

    default public void sessionPeerIdentificationReceived(Session session, String version, List<String> extraLines) {
    }

    default public void sessionNegotiationOptionsCreated(Session session, Map<KexProposalOption, String> proposal) {
    }

    default public void sessionNegotiationStart(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal) {
    }

    default public void sessionNegotiationEnd(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal, Map<KexProposalOption, String> negotiatedOptions, Throwable reason) {
    }

    default public void sessionEvent(Session session, Event event) {
    }

    default public void sessionException(Session session, Throwable t2) {
    }

    default public void sessionDisconnect(Session session, int reason, String msg, String language, boolean initiator) {
    }

    default public void sessionClosed(Session session) {
    }

    public static <L extends SessionListener> L validateListener(L listener) {
        return SshdEventListener.validateListener(listener, SessionListener.class.getSimpleName());
    }

    public static enum Event {
        KeyEstablished,
        Authenticated,
        KexCompleted;

    }
}

