/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.NumberUtils;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <T> T checkNotNull(T t2, String message) {
        ValidateUtils.checkTrue(t2 != null, message);
        return t2;
    }

    public static <T> T checkNotNull(T t2, String message, Object arg) {
        ValidateUtils.checkTrue(t2 != null, message, arg);
        return t2;
    }

    public static <T> T checkNotNull(T t2, String message, long value) {
        ValidateUtils.checkTrue(t2 != null, message, value);
        return t2;
    }

    public static <T> T checkNotNull(T t2, String message, Object ... args) {
        ValidateUtils.checkTrue(t2 != null, message, args);
        return t2;
    }

    public static String checkNotNullAndNotEmpty(String t2, String message) {
        ValidateUtils.checkTrue(GenericUtils.length(t2 = ValidateUtils.checkNotNull(t2, message).trim()) > 0, message);
        return t2;
    }

    public static String checkNotNullAndNotEmpty(String t2, String message, Object arg) {
        ValidateUtils.checkTrue(GenericUtils.length(t2 = ValidateUtils.checkNotNull(t2, message, arg).trim()) > 0, message, arg);
        return t2;
    }

    public static String checkNotNullAndNotEmpty(String t2, String message, Object ... args) {
        ValidateUtils.checkTrue(GenericUtils.length(t2 = ValidateUtils.checkNotNull(t2, message, args).trim()) > 0, message, args);
        return t2;
    }

    public static <K, V, M extends Map<K, V>> M checkNotNullAndNotEmpty(M t2, String message, Object ... args) {
        ValidateUtils.checkNotNull(t2, message, args);
        ValidateUtils.checkTrue(MapEntryUtils.size(t2) > 0, message, args);
        return t2;
    }

    public static <T, C extends Collection<T>> C checkNotNullAndNotEmpty(C t2, String message, Object ... args) {
        ValidateUtils.checkNotNull(t2, message, args);
        ValidateUtils.checkTrue(GenericUtils.size(t2) > 0, message, args);
        return t2;
    }

    public static <T, C extends Iterable<T>> C checkNotNullAndNotEmpty(C t2, String message, Object ... args) {
        ValidateUtils.checkNotNull(t2, message, args);
        ValidateUtils.checkTrue(GenericUtils.isNotEmpty(t2), message, args);
        return t2;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] a, String message) {
        ValidateUtils.checkNotNull(a, message);
        ValidateUtils.checkTrue(NumberUtils.length(a) > 0, message);
        return a;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] a, String message, Object ... args) {
        ValidateUtils.checkNotNull(a, message, args);
        ValidateUtils.checkTrue(NumberUtils.length(a) > 0, message, args);
        return a;
    }

    public static char[] checkNotNullAndNotEmpty(char[] a, String message) {
        ValidateUtils.checkNotNull(a, message);
        ValidateUtils.checkTrue(GenericUtils.length(a) > 0, message);
        return a;
    }

    public static char[] checkNotNullAndNotEmpty(char[] a, String message, Object ... args) {
        ValidateUtils.checkNotNull(a, message, args);
        ValidateUtils.checkTrue(GenericUtils.length(a) > 0, message, args);
        return a;
    }

    public static int[] checkNotNullAndNotEmpty(int[] a, String message) {
        ValidateUtils.checkNotNull(a, message);
        ValidateUtils.checkTrue(NumberUtils.length(a) > 0, message);
        return a;
    }

    public static int[] checkNotNullAndNotEmpty(int[] a, String message, Object ... args) {
        ValidateUtils.checkNotNull(a, message, args);
        ValidateUtils.checkTrue(NumberUtils.length(a) > 0, message, args);
        return a;
    }

    public static <T> T[] checkNotNullAndNotEmpty(T[] t2, String message, Object ... args) {
        ValidateUtils.checkNotNull(t2, message, args);
        ValidateUtils.checkTrue(GenericUtils.length(t2) > 0, message, args);
        return t2;
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message, long value) {
        Class<?> actual = ValidateUtils.checkNotNull(v, message, value).getClass();
        ValidateUtils.checkTrue(expected.isAssignableFrom(actual), message, value);
        return expected.cast(v);
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message) {
        return ValidateUtils.checkInstanceOf(v, expected, message, GenericUtils.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message, Object arg) {
        Class<?> actual = ValidateUtils.checkNotNull(v, message, arg).getClass();
        ValidateUtils.checkTrue(expected.isAssignableFrom(actual), message, arg);
        return expected.cast(v);
    }

    public static <T> T checkInstanceOf(Object v, Class<T> expected, String message, Object ... args) {
        Class<?> actual = ValidateUtils.checkNotNull(v, message, args).getClass();
        ValidateUtils.checkTrue(expected.isAssignableFrom(actual), message, args);
        return expected.cast(v);
    }

    public static void checkTrue(boolean flag, String message) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkTrue(boolean flag, String message, long value) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, value);
        }
    }

    public static void checkTrue(boolean flag, String message, Object arg) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, arg);
        }
    }

    public static void checkTrue(boolean flag, String message, Object ... args) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, args);
        }
    }

    public static void throwIllegalArgumentException(String format, Object ... args) {
        throw ValidateUtils.createFormattedException(IllegalArgumentException::new, format, args);
    }

    public static void checkState(boolean flag, String message) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkState(boolean flag, String message, long value) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, value);
        }
    }

    public static void checkState(boolean flag, String message, Object arg) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, arg);
        }
    }

    public static void checkState(boolean flag, String message, Object ... args) {
        if (!flag) {
            ValidateUtils.throwIllegalStateException(message, args);
        }
    }

    public static void throwIllegalStateException(String format, Object ... args) {
        throw ValidateUtils.createFormattedException(IllegalStateException::new, format, args);
    }

    public static <T extends Throwable> T createFormattedException(Function<? super String, ? extends T> constructor, String format, Object ... args) {
        String message = String.format(format, args);
        return (T)((Throwable)constructor.apply(message));
    }

    public static <T extends Throwable> T initializeExceptionCause(T err, Throwable cause) {
        if (cause == null) {
            return err;
        }
        if (err.getCause() != null) {
            return err;
        }
        err.initCause(cause);
        return err;
    }
}

