/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ProxyUtils;
import org.apache.sshd.common.util.closeable.AutoCloseableDelegateInvocationHandler;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioChannelDelegateInvocationHandler
extends AutoCloseableDelegateInvocationHandler {
    public NioChannelDelegateInvocationHandler(Object proxyTarget, Channel delegate) {
        super(proxyTarget, delegate);
    }

    public Channel getChannelDelegate() {
        return (Channel)Channel.class.cast(super.getAutoCloseableDelegate());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!NioChannelDelegateInvocationHandler.isQueryOpenMethodInvocation(method, args)) {
            return super.invoke(proxy, method, args);
        }
        Channel channelDelegate = this.getChannelDelegate();
        try {
            return method.invoke((Object)channelDelegate, args);
        }
        catch (Throwable t2) {
            Class<?> targetType = channelDelegate.getClass();
            Logger log = LoggerFactory.getLogger(targetType);
            LoggingUtils.debug(log, "invoke({}#{}) failed ({}) to execute: {}", targetType.getSimpleName(), method.getName(), t2.getClass().getSimpleName(), t2.getMessage(), t2);
            throw ProxyUtils.unwrapInvocationThrowable(t2);
        }
    }

    public static <T extends Channel> T wrapDelegateChannel(Object proxyTarget, Class<T> type, Channel delegate) {
        return (T)((Channel)ProxyUtils.newProxyInstance(type, new NioChannelDelegateInvocationHandler(proxyTarget, delegate)));
    }

    public static boolean isQueryOpenMethodInvocation(Method m4, Object[] args) {
        return NioChannelDelegateInvocationHandler.isQueryOpenMethodInvocation(m4) && GenericUtils.isEmpty(args);
    }

    public static boolean isQueryOpenMethodInvocation(Method m4) {
        int mods = m4 == null ? 0 : m4.getModifiers();
        return m4 != null && "isOpen".equals(m4.getName()) && Modifier.isPublic(mods) && !Modifier.isStatic(mods) && Boolean.TYPE == m4.getReturnType() && GenericUtils.isEmpty(m4.getParameterTypes());
    }
}

