/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;

public class LazyMatchingTypeIterator<T>
implements Iterator<T> {
    protected boolean finished;
    protected T nextValue;
    private final Iterator<?> values;
    private final Class<T> type;

    public LazyMatchingTypeIterator(Iterator<?> values, Class<T> type) {
        this.values = values;
        this.type = Objects.requireNonNull(type, "No type selector specified");
    }

    public Iterator<?> getValues() {
        return this.values;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        this.nextValue = GenericUtils.selectNextMatchingValue(this.getValues(), this.getType());
        if (this.nextValue == null) {
            this.finished = true;
        }
        return !this.finished;
    }

    @Override
    public T next() {
        if (this.finished) {
            throw new NoSuchElementException("All values have been exhausted");
        }
        if (this.nextValue == null) {
            throw new IllegalStateException("'next()' called without asking 'hasNext()'");
        }
        T v = this.nextValue;
        this.nextValue = null;
        return v;
    }

    public String toString() {
        Class<T> t2 = this.getType();
        return Iterator.class.getSimpleName() + "[lazy-select](" + t2.getSimpleName() + ")";
    }

    public static <T> Iterator<T> lazySelectMatchingTypes(Iterator<?> values, Class<T> type) {
        Objects.requireNonNull(type, "No type selector specified");
        return values == null ? Collections.emptyIterator() : new LazyMatchingTypeIterator<T>(values, type);
    }
}

