/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.der;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;

public enum ASN1Type {
    ANY(0),
    BOOLEAN(1),
    INTEGER(2),
    BIT_STRING(3),
    OCTET_STRING(4),
    NULL(5),
    OBJECT_IDENTIFIER(6),
    REAL(9),
    ENUMERATED(10),
    RELATIVE_OID(13),
    SEQUENCE(16),
    SET(17),
    NUMERIC_STRING(18),
    PRINTABLE_STRING(19),
    T61_STRING(20),
    VIDEOTEX_STRING(21),
    IA5_STRING(22),
    GRAPHIC_STRING(25),
    ISO646_STRING(26),
    GENERAL_STRING(27),
    UTF8_STRING(12),
    UNIVERSAL_STRING(28),
    BMP_STRING(30),
    UTC_TIME(23),
    GENERALIZED_TIME(24);

    public static final Set<ASN1Type> VALUES;
    private final byte typeValue;

    private ASN1Type(byte typeVal) {
        this.typeValue = typeVal;
    }

    public byte getTypeValue() {
        return this.typeValue;
    }

    public static ASN1Type fromName(String s2) {
        if (GenericUtils.isEmpty(s2)) {
            return null;
        }
        for (ASN1Type t2 : VALUES) {
            if (!s2.equalsIgnoreCase(t2.name())) continue;
            return t2;
        }
        return null;
    }

    public static ASN1Type fromDERValue(int value) {
        return ASN1Type.fromTypeValue(value & 0x1F);
    }

    public static ASN1Type fromTypeValue(int value) {
        if (value < 0 || value > 31) {
            return null;
        }
        for (ASN1Type t2 : VALUES) {
            if (t2.getTypeValue() != value) continue;
            return t2;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(ASN1Type.class));
    }
}

