/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SshdThreadFactory
extends AbstractLoggingBean
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public SshdThreadFactory(String name) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        String effectiveName = name.replace(' ', '-');
        this.namePrefix = "sshd-" + effectiveName + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t2;
        try {
            t2 = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L)) : new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        }
        catch (PrivilegedActionException e) {
            Exception err = e.getException();
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new IllegalStateException(err);
        }
        if (!t2.isDaemon()) {
            t2.setDaemon(true);
        }
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newThread({})[{}] runnable={}", this.group, t2.getName(), r);
        }
        return t2;
    }
}

