/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.config.SshServerConfigFileReader;

public final class SftpModuleProperties {
    public static final Property<Charset> NAME_DECODING_CHARSET = Property.charset("sftp-name-decoding-charset", StandardCharsets.UTF_8);
    public static final Property<Duration> SFTP_CHANNEL_OPEN_TIMEOUT = Property.duration("sftp-channel-open-timeout", Duration.ofSeconds(15L));
    public static final Property<Integer> POOL_SIZE = Property.integer("sftp-fs-pool-size", 8);
    public static final Property<Integer> READ_BUFFER_SIZE = Property.integer("sftp-fs-read-buffer-size");
    public static final Property<Integer> WRITE_BUFFER_SIZE = Property.integer("sftp-fs-write-buffer-size");
    public static final Property<Duration> CONNECT_TIME = Property.duration("sftp-fs-connect-time", Duration.ofSeconds(15L));
    public static final Property<Duration> AUTH_TIME = Property.duration("sftp-fs-auth-time", Duration.ofSeconds(15L));
    public static final Property<Charset> NAME_DECODER_CHARSET = Property.charset("sftp-fs-name-decoder-charset", StandardCharsets.UTF_8);
    public static final Property<Integer> WRITE_CHUNK_SIZE = Property.integer("sftp-client-write-chunk-size", 32704);
    public static final Property<Integer> COPY_BUF_SIZE = Property.integer("sftp-channel-copy-buf-size", 8192);
    public static final Property<Boolean> APPEND_END_OF_LIST_INDICATOR = Property.bool("sftp-append-eol-indicator", true);
    public static final Property<Boolean> AUTO_FOLLOW_LINKS = Property.bool("sftp-auto-follow-links", true);
    public static final Property<String> CLIENT_EXTENSIONS = Property.string("sftp-client-extensions");
    public static final Property<String> OPENSSH_EXTENSIONS = Property.string("sftp-openssh-extensions");
    public static final Property<String> ACL_SUPPORTED_MASK = Property.string("sftp-acl-supported-mask");
    public static final Property<String> NEWLINE_VALUE = Property.string("sftp-newline", IoUtils.EOL);
    public static final Property<Integer> MAX_READDATA_PACKET_LENGTH = Property.integer("sftp-max-readdata-packet-length", 64512);
    public static final Property<Integer> MAX_OPEN_HANDLES_PER_SESSION = Property.integer("max-open-handles-per-session", Integer.MAX_VALUE);
    public static final int MIN_FILE_HANDLE_SIZE = 4;
    public static final int DEFAULT_FILE_HANDLE_SIZE = 16;
    public static final int MAX_FILE_HANDLE_SIZE = 64;
    public static final Property<Integer> FILE_HANDLE_SIZE = Property.validating(Property.integer("sftp-handle-size", 16), fhs -> {
        ValidateUtils.checkTrue(fhs >= 4, "File handle size too small: %d", fhs);
        ValidateUtils.checkTrue(fhs <= 64, "File handle size too big: %d", fhs);
    });
    public static final int MIN_FILE_HANDLE_ROUNDS = 1;
    public static final int DEFAULT_FILE_HANDLE_ROUNDS = 4;
    public static final int MAX_FILE_HANDLE_ROUNDS = 64;
    public static final Property<Integer> MAX_FILE_HANDLE_RAND_ROUNDS = Property.validating(Property.integer("sftp-handle-rand-max-rounds", 4), fhrr -> {
        ValidateUtils.checkTrue(fhrr >= 1, "File handle rounds too small: %d", fhrr);
        ValidateUtils.checkTrue(fhrr <= 64, "File handle rounds too big: %d", fhrr);
    });
    public static final Property<Integer> MAX_READDIR_DATA_SIZE = Property.integer("sftp-max-readdir-data-size", 16384);
    public static final Property<Integer> SFTP_VERSION = SshServerConfigFileReader.SFTP_FORCED_VERSION_PROP;

    private SftpModuleProperties() {
        throw new UnsupportedOperationException("No instance");
    }
}

