/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpPath;

public class SftpPathIterator
implements Iterator<Path> {
    protected final Iterator<? extends SftpClient.DirEntry> it;
    protected boolean dotIgnored;
    protected boolean dotdotIgnored;
    protected SftpPath curEntry;
    private final SftpPath path;
    private DirectoryStream.Filter<? super Path> filter;

    public SftpPathIterator(SftpPath path, Iterable<? extends SftpClient.DirEntry> iter) {
        this(path, iter, null);
    }

    public SftpPathIterator(SftpPath path, Iterable<? extends SftpClient.DirEntry> iter, DirectoryStream.Filter<? super Path> filter) {
        this(path, iter == null ? null : iter.iterator(), filter);
    }

    public SftpPathIterator(SftpPath path, Iterator<? extends SftpClient.DirEntry> iter) {
        this(path, iter, null);
    }

    public SftpPathIterator(SftpPath path, Iterator<? extends SftpClient.DirEntry> iter, DirectoryStream.Filter<? super Path> filter) {
        this.path = Objects.requireNonNull(path, "No root path provided");
        this.filter = filter;
        this.it = iter;
        this.curEntry = this.nextEntry(path, filter);
    }

    public final SftpPath getRootPath() {
        return this.path;
    }

    public final DirectoryStream.Filter<? super Path> getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasNext() {
        return this.curEntry != null;
    }

    @Override
    public Path next() {
        if (this.curEntry == null) {
            throw new NoSuchElementException("No next entry");
        }
        SftpPath returnValue = this.curEntry;
        this.curEntry = this.nextEntry(this.getRootPath(), this.getFilter());
        return returnValue;
    }

    protected SftpPath nextEntry(SftpPath root, DirectoryStream.Filter<? super Path> selector) {
        while (this.it != null && this.it.hasNext()) {
            SftpClient.DirEntry entry = this.it.next();
            String name = entry.getFilename();
            if (".".equals(name) && !this.dotIgnored) {
                this.dotIgnored = true;
                continue;
            }
            if ("..".equals(name) && !this.dotdotIgnored) {
                this.dotdotIgnored = true;
                continue;
            }
            SftpPath candidate = (SftpPath)root.resolve(entry.getFilename());
            try {
                if (selector != null && !selector.accept(candidate)) continue;
                return candidate;
            }
            catch (IOException e) {
                throw new DirectoryIteratorException(e);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("newDirectoryStream(" + this.getRootPath() + ") Iterator#remove() N/A");
    }
}

