/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SimpleSftpClient;

public class SimpleSftpClientImpl
extends AbstractLoggingBean
implements SimpleSftpClient {
    private SimpleClient clientInstance;
    private SftpClientFactory sftpClientFactory;

    public SimpleSftpClientImpl() {
        this((SimpleClient)null);
    }

    public SimpleSftpClientImpl(SimpleClient client) {
        this(client, null);
    }

    public SimpleSftpClientImpl(SimpleClient client, SftpClientFactory sftpClientFactory) {
        this.clientInstance = client;
        this.setSftpClientFactory(sftpClientFactory);
    }

    public SimpleClient getClient() {
        return this.clientInstance;
    }

    public void setClient(SimpleClient client) {
        this.clientInstance = client;
    }

    public SftpClientFactory getSftpClientFactory() {
        return this.sftpClientFactory;
    }

    public void setSftpClientFactory(SftpClientFactory sftpClientFactory) {
        this.sftpClientFactory = sftpClientFactory != null ? sftpClientFactory : SftpClientFactory.instance();
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, String password) throws IOException {
        return this.createSftpClient((? super SimpleClient client) -> client.sessionLogin(target, username, password));
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.createSftpClient((? super SimpleClient client) -> client.sessionLogin(target, username, identity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SftpClient createSftpClient(IOFunction<? super SimpleClient, ? extends ClientSession> sessionProvider) throws IOException {
        SimpleClient client = this.getClient();
        try (ClientSession session = sessionProvider.apply(client);){
            SftpClient sftp = this.createSftpClient(session);
            session = null;
            SftpClient sftpClient = sftp;
            return sftpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SftpClient createSftpClient(ClientSession session) throws IOException {
        Exception err = null;
        try {
            SftpClient client = this.sftpClientFactory.createSftpClient(session);
            try {
                SftpClient closer = client.singleSessionInstance();
                client = null;
                SftpClient sftpClient = closer;
                return sftpClient;
            }
            catch (Exception e) {
                err = ExceptionUtils.accumulateException(err, e);
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Exception t3) {
                        this.debug("createSftpClient({}) failed ({}) to close client: {}", session, t3.getClass().getSimpleName(), t3.getMessage(), t3);
                        err = ExceptionUtils.accumulateException(err, t3);
                    }
                }
            }
        }
        catch (Exception e2) {
            err = ExceptionUtils.accumulateException(err, e2);
        }
        this.log.warn("createSftpClient({}) failed ({}) to create client: {}", session, err.getClass().getSimpleName(), err.getMessage());
        try {
            session.close();
        }
        catch (Exception e) {
            this.debug("createSftpClient({}) failed ({}) to close session: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
            err = ExceptionUtils.accumulateException(err, e);
        }
        if (!(err instanceof IOException)) throw new IOException(err);
        throw (IOException)err;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

