/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.inject.Named;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.archiver.tar.TarResource;
import org.codehaus.plexus.archiver.tar.TarSymlinkResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

@Named(value="tar")
public class PlexusIoTarFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements Closeable {
    TarFile tarFile = null;

    protected TarFile newTarFile(File file) {
        return new TarFile(file);
    }

    @Override
    public void close() throws IOException {
        if (this.tarFile != null) {
            this.tarFile.close();
        }
    }

    @Override
    public boolean isConcurrentAccessSupported() {
        return false;
    }

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        if (this.tarFile == null) {
            this.tarFile = this.newTarFile(f);
        }
        final Enumeration<ArchiveEntry> en = this.tarFile.getEntries();
        return new Iterator<PlexusIoResource>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public PlexusIoResource next() {
                TarArchiveEntry entry = (TarArchiveEntry)en.nextElement();
                return entry.isSymbolicLink() ? new TarSymlinkResource(PlexusIoTarFileResourceCollection.this.tarFile, entry) : new TarResource(PlexusIoTarFileResourceCollection.this.tarFile, entry);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing isn't implemented.");
            }
        };
    }
}

