/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.velocity;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class DefaultVelocityComponent
extends AbstractLogEnabled
implements VelocityComponent,
Initializable,
LogChute {
    private VelocityEngine engine;
    private Properties properties;
    private RuntimeServices runtimeServices;

    public void initialize() throws InitializationException {
        this.engine = new VelocityEngine();
        this.engine.setProperty("velocimacro.library", "");
        this.engine.setProperty("runtime.log.logsystem", this);
        if (this.properties != null) {
            Enumeration<?> e = this.properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                String value = this.properties.getProperty(key);
                this.engine.setProperty(key, value);
                this.getLogger().debug("Setting property: " + key + " => '" + value + "'.");
            }
        }
        try {
            this.engine.init();
        }
        catch (Exception e) {
            throw new InitializationException("Cannot start the Velocity engine", e);
        }
    }

    public VelocityEngine getEngine() {
        return this.engine;
    }

    public void init(RuntimeServices runtimeServices) {
        this.runtimeServices = runtimeServices;
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message);
                break;
            }
            case 1: {
                this.getLogger().info(message);
                break;
            }
            case -1: 
            case 0: {
                this.getLogger().debug(message);
                break;
            }
            case 3: {
                this.getLogger().error(message);
                break;
            }
            default: {
                this.getLogger().debug(message);
            }
        }
    }

    public void log(int level, String message, Throwable t2) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message, t2);
                break;
            }
            case 1: {
                this.getLogger().info(message, t2);
                break;
            }
            case -1: 
            case 0: {
                this.getLogger().debug(message, t2);
                break;
            }
            case 3: {
                this.getLogger().error(message, t2);
                break;
            }
            default: {
                this.getLogger().debug(message, t2);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 2: {
                return this.getLogger().isWarnEnabled();
            }
            case 1: {
                return this.getLogger().isInfoEnabled();
            }
            case -1: 
            case 0: {
                return this.getLogger().isDebugEnabled();
            }
            case 3: {
                return this.getLogger().isErrorEnabled();
            }
        }
        return this.getLogger().isDebugEnabled();
    }
}

