/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.internal.transport.sshd.GssApiMechanisms;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GssApiWithMicAuthentication
extends AbstractUserAuth {
    private static final byte SSH_MSG_USERAUTH_GSSAPI_RESPONSE = 60;
    private static final byte SSH_MSG_USERAUTH_GSSAPI_TOKEN = 61;
    private Collection<Oid> mechanisms;
    private Iterator<Oid> nextMechanism;
    private Oid currentMechanism;
    private ProtocolState state;
    private GSSContext context;

    public GssApiWithMicAuthentication() {
        super("gssapi-with-mic");
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        if (this.mechanisms == null) {
            this.mechanisms = GssApiMechanisms.getSupportedMechanisms();
            this.nextMechanism = this.mechanisms.iterator();
        }
        if (this.context != null) {
            this.close(false);
        }
        if (!this.nextMechanism.hasNext()) {
            return false;
        }
        this.state = ProtocolState.STARTED;
        this.currentMechanism = this.nextMechanism.next();
        while (GssApiMechanisms.SPNEGO.equals(this.currentMechanism)) {
            if (!this.nextMechanism.hasNext()) {
                return false;
            }
            this.currentMechanism = this.nextMechanism.next();
        }
        try {
            String hostName = this.getHostName(session);
            this.context = GssApiMechanisms.createContext(this.currentMechanism, hostName);
            this.context.requestMutualAuth(true);
            this.context.requestConf(true);
            this.context.requestInteg(true);
            this.context.requestCredDeleg(true);
            this.context.requestAnonymity(false);
        }
        catch (NullPointerException | GSSException e) {
            this.close(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug(MessageFormat.format(SshdText.get().gssapiInitFailure, this.currentMechanism.toString()));
            }
            this.currentMechanism = null;
            this.state = ProtocolState.FAILED;
            return false;
        }
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(this.getName());
        buffer.putInt(1L);
        buffer.putBytes(this.currentMechanism.getDER());
        session.writePacket(buffer);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer in) throws Exception {
        int command = in.getUByte();
        if (this.context == null) {
            return false;
        }
        try {
            switch (command) {
                case 60: {
                    if (this.state != ProtocolState.STARTED) {
                        return this.unexpectedMessage(command);
                    }
                    Oid mechanism = new Oid(in.getBytes());
                    if (!this.currentMechanism.equals(mechanism)) {
                        return false;
                    }
                    this.replyToken(session, service, new byte[0]);
                    return true;
                }
                case 61: {
                    if (!this.context.isEstablished() && this.state == ProtocolState.TOKENS) {
                        this.replyToken(session, service, in.getBytes());
                        return true;
                    }
                    return this.unexpectedMessage(command);
                }
            }
            return this.unexpectedMessage(command);
        }
        catch (GSSException e) {
            this.log.warn(MessageFormat.format(SshdText.get().gssapiFailure, this.currentMechanism.toString()), e);
            this.state = ProtocolState.FAILED;
            return false;
        }
    }

    @Override
    public void destroy() {
        try {
            this.close(false);
        }
        finally {
            super.destroy();
        }
    }

    private void close(boolean silent) {
        block3: {
            try {
                if (this.context != null) {
                    this.context.dispose();
                    this.context = null;
                }
            }
            catch (GSSException e) {
                if (silent) break block3;
                this.log.warn(SshdText.get().gssapiFailure, e);
            }
        }
    }

    private void sendToken(ClientSession session, byte[] receivedToken) throws IOException, GSSException {
        this.state = ProtocolState.TOKENS;
        byte[] token = this.context.initSecContext(receivedToken, 0, receivedToken.length);
        if (token != null) {
            Buffer buffer = session.createBuffer((byte)61);
            buffer.putBytes(token);
            session.writePacket(buffer);
        }
    }

    private void sendMic(ClientSession session, String service) throws IOException, GSSException {
        this.state = ProtocolState.MIC_SENT;
        ByteArrayBuffer micBuffer = new ByteArrayBuffer();
        micBuffer.putBytes(session.getSessionId());
        ((Buffer)micBuffer).putByte((byte)50);
        micBuffer.putString(session.getUsername());
        micBuffer.putString(service);
        micBuffer.putString(this.getName());
        byte[] micBytes = micBuffer.getCompactData();
        byte[] mic = this.context.getMIC(micBytes, 0, micBytes.length, new MessageProp(0, true));
        Buffer buffer = session.createBuffer((byte)66);
        buffer.putBytes(mic);
        session.writePacket(buffer);
    }

    private void replyToken(ClientSession session, String service, byte[] bytes) throws IOException, GSSException {
        this.sendToken(session, bytes);
        if (this.context.isEstablished()) {
            this.sendMic(session, service);
        }
    }

    private String getHostName(ClientSession session) {
        InetAddress address;
        SocketAddress remote = session.getConnectAddress();
        if (remote instanceof InetSocketAddress && (address = GssApiMechanisms.resolve((InetSocketAddress)remote)) != null) {
            return address.getCanonicalHostName();
        }
        if (session instanceof JGitClientSession) {
            String hostName = ((JGitClientSession)session).getHostConfigEntry().getHostName();
            try {
                hostName = InetAddress.getByName(hostName).getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return hostName;
        }
        throw new IllegalStateException("Wrong session class :" + session.getClass().getName());
    }

    private boolean unexpectedMessage(int command) {
        this.log.warn(MessageFormat.format(SshdText.get().gssapiUnexpectedMessage, this.getName(), Integer.toString(command)));
        return false;
    }

    private static enum ProtocolState {
        STARTED,
        TOKENS,
        MIC_SENT,
        FAILED;

    }
}

