/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.text.MessageFormat;
import java.util.List;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.signature.Signature;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.util.StringUtils;

public class JGitPublicKeyAuthentication
extends UserAuthPublicKey {
    JGitPublicKeyAuthentication(List<NamedFactory<Signature>> factories) {
        super(factories);
    }

    @Override
    public void init(ClientSession rawSession, String service) throws Exception {
        if (!(rawSession instanceof JGitClientSession)) {
            throw new IllegalStateException("Wrong session type: " + rawSession.getClass().getCanonicalName());
        }
        JGitClientSession session = (JGitClientSession)rawSession;
        HostConfigEntry hostConfig = session.getHostConfigEntry();
        String pubkeyAlgos = hostConfig.getProperty("PubkeyAcceptedAlgorithms");
        if (!StringUtils.isEmptyOrNull(pubkeyAlgos)) {
            List<String> signatures = session.getSignatureFactoriesNames();
            if (!(signatures = session.modifyAlgorithmList(signatures, session.getAllAvailableSignatureAlgorithms(), pubkeyAlgos, "PubkeyAcceptedAlgorithms")).isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PubkeyAcceptedAlgorithms " + signatures);
                }
                this.setSignatureFactoriesNames(signatures);
            } else {
                this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "PubkeyAcceptedAlgorithms", pubkeyAlgos));
            }
        }
        super.init(session, service);
    }
}

